/*
 * JBoss, Home of Professional Open Source.
 * See the COPYRIGHT.txt file distributed with this work for information
 * regarding copyright ownership.  Some portions may be licensed
 * to Red Hat, Inc. under one or more contributor license agreements.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 */

package org.teiid.query.sql.navigator;

import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.symbol.ScalarSubquery;


/** 
 * @since 4.2
 */
public class DeepPostOrderNavigator extends PostOrderNavigator {

    public DeepPostOrderNavigator(LanguageVisitor visitor) {
        super(visitor);
    }

    public void visit(ExistsCriteria obj) {
        visitNode(obj.getCommand());
        visitVisitor(obj);
    }
    public void visit(ScalarSubquery obj) {
        visitNode(obj.getCommand());
        visitVisitor(obj);
    }
    public void visit(SubqueryCompareCriteria obj) {
        visitNode(obj.getLeftExpression());
        visitNode(obj.getCommand());
        visitVisitor(obj);
    }
    public void visit(SubqueryFromClause obj) {
        visitNode(obj.getCommand());
        visitNode(obj.getGroupSymbol());
        visitVisitor(obj);
    }
    public void visit(SubquerySetCriteria obj) {
        visitNode(obj.getCommand());
        visitNode(obj.getExpression());
        visitVisitor(obj);
    }
    public void visit(Insert obj) {
        visitNode(obj.getGroup());
        visitNodes(obj.getVariables());
        visitNodes(obj.getValues());
        if(obj.getQueryExpression()!=null) {
        	visitNode(obj.getQueryExpression());
        }
        visitNode(obj.getOption());
        visitVisitor(obj);
    }
    
    public static void doVisit(LanguageObject object, LanguageVisitor visitor) {
        DeepPostOrderNavigator nav = new DeepPostOrderNavigator(visitor);
        object.acceptVisitor(nav);
    }

}
