package org.jboss.soa.esb.qa.teargas.message.generator;

import java.io.Serializable;
import org.jboss.soa.esb.qa.teargas.message.sender.MessageSender;

/**
 *
 * @author pmacik
 */
public abstract class AbstractMessageGenerator {

    protected MessageSender sender;
    protected int threads = 1;

    public void setProperty(String property, String value) {
        if ("threads".equals(property)) {
            threads = Integer.valueOf(value);
        }
    }

    public void init(String address, MessageSender sender) throws Exception {
        this.sender = sender;
        this.sender.init(address);
    }

    public void close() {
        sender.close();
    }

    public abstract void generate(Serializable message, int count) throws Exception;
}
