/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.samples.quickstart.purchase;

import java.util.logging.Level;
import java.util.logging.Logger;

import javax.annotation.PostConstruct;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.WebServiceRef;

/**
 * Asynchronous shipping callback bean.
 * 
 * @author Jeff DeLong
 * @author Alejandro Guizar
 */
@MessageDriven(activationConfig = {
		@ActivationConfigProperty(propertyName = "destinationType", propertyValue = "javax.jms.Queue"),
		@ActivationConfigProperty(propertyName = "destination", propertyValue = "queue/ShippingQueue") })
public class ShippingCallbackBean implements MessageListener {

	@WebServiceRef
	private PurchaseSVC purchaseService;

	private DatatypeFactory datatypeFactory;

	private final Logger log =
			Logger.getLogger(ShippingCallbackBean.class.getName());

	@PostConstruct
	void createDatatypeFactory() {
		try {
			datatypeFactory = DatatypeFactory.newInstance();
		}
		catch (DatatypeConfigurationException e) {
			throw new AssertionError(e);
		}
	}

	/**
	 * Process the shipping message.
	 */
	public void onMessage(Message msg) {
		// populate schedule info; for now the message contents are irrelevant
		XMLGregorianCalendar shipDate = datatypeFactory.newXMLGregorianCalendar();
		ScheduleInfo schedule = new ScheduleInfo();
		schedule.setShipDate(shipDate);

		// send schedule back to requester
		purchaseService.getShippingCallbackSP().sendSchedule(schedule);
		log.log(Level.FINE, "sent shiping schedule on {0,date}", shipDate);
	}
}
