package org.jboss.soa.bpel.tests.tutorials.BluePrint1;

import junit.framework.Test;

import org.jboss.soa.bpel.tests.RiftSawTest;
import org.jboss.soa.bpel.tests.RiftSawTestSetup;

public class BluePrint1TestCase extends RiftSawTest {

	private static final String TEST_NAME = "BluePrint1";

	public BluePrint1TestCase() {
		super(TEST_NAME);
	}

	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}
	
	public static Test suite() {
		return(new RiftSawTestSetup(BluePrint1TestCase.class,
						TEST_NAME, "BluePrint1-1.jar"));
	}

	public void testSendValid() throws Exception {
		String result=sendSOAPMessage("valid.xml",
					"http://localhost:8080/BPEL_BluePrint1_PurchaseOrderService");
		
		result = processResult(result);
		
		assertMessageFromFile(result, "valid_response.xml");
	}

	public void testSendInvalid() throws Exception {
		String result=sendSOAPMessage("invalid.xml",
					"http://localhost:8080/BPEL_BluePrint1_PurchaseOrderService");
		
		result = processResult(result);
		
		assertMessageFromFile(result, "invalid_response.xml");
	}

}
