/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.tests.samples;

import org.jboss.soa.bpel.tests.RiftSawTest;
import org.jboss.soa.bpel.tests.RiftSawTestSetup;

import junit.framework.Test;

/**
 * Test case for running the Quickstart_bpel_loan_fault sample.
 */
public class QuickstartESBBPELLoanFaultTestCase extends RiftSawTest {

	private static final String TEST_NAME = "Quickstart_esb_bpel_loan_fault";
	protected static final String BODY_FAULT_CODE = "org.jboss.soa.esb.message.fault.detail.code";
	protected static final String BODY_BPEL_FAULT_CODE = "org.jboss.soa.bpel.message.fault.detail.code";
	protected static final String BODY_FAULT_MESSAGE = "org.jboss.soa.esb.message.fault.detail.detail";

	public QuickstartESBBPELLoanFaultTestCase() {
		super(TEST_NAME);
	}
	
	public static Test suite() {
		return(new RiftSawTestSetup(QuickstartESBBPELLoanFaultTestCase.class,
						TEST_NAME, "Quickstart_esb_bpel_loan_fault.esb,../Quickstart_bpel_loan_approval/Quickstart_bpel_loan_approval-1.jar,../Quickstart_bpel_loan_approval/Quickstart_bpel_loan_approval.war"));
	}

	public void testSendLoanRequestZeroAmountException() throws Exception {
		try {
			String result=sendESBMessage("<request><firstName>Jane</firstName><name>Bloggs</name><amount>0</amount></request>",
								"LoanFaultBPELESB", "LoanFailException");
		
			fail("Test should have failed with FaultMessageException");
			
		} catch(org.jboss.soa.esb.couriers.FaultMessageException fme) {
			
			assertMessage((String)fme.getReturnedMessage().getBody().get(BODY_FAULT_MESSAGE),
					"<message><errorCode><integer xmlns=\"http://example.com/loan-approval/xsd/error-messages/\">1</integer></errorCode></message>");

			assertMessage((String)fme.getReturnedMessage().getBody().get(BODY_BPEL_FAULT_CODE),
					"{http://example.com/loan-approval/wsdl/}unableToHandleRequest");
			
		} catch(Exception e) {
			fail("Test failed with exception: "+e);
		}
	}

	public void testSendLoanRequestZeroAmountFaultMessage() throws Exception {
		try {
			String result=sendESBMessage("<request><firstName>Jane</firstName><name>Bloggs</name><amount>0</amount></request>",
								"LoanFaultBPELESB", "LoanFailMessage");
		
			fail("Test should have failed with FaultMessageException");
			
		} catch(org.jboss.soa.esb.couriers.FaultMessageException fme) {
			
			assertMessage((String)fme.getReturnedMessage().getBody().get(BODY_FAULT_MESSAGE),
					"<message><errorCode><integer xmlns=\"http://example.com/loan-approval/xsd/error-messages/\">1</integer></errorCode></message>");
			
			assertMessage((String)fme.getReturnedMessage().getBody().get(BODY_BPEL_FAULT_CODE),
					"{http://example.com/loan-approval/wsdl/}unableToHandleRequest");
			
		} catch(Exception e) {
			fail("Test failed with exception: "+e);
		}
	}
}
