/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.security.opensso;

import static org.junit.Assert.*;

import java.util.HashMap;
import java.util.Map;

import javax.security.auth.Subject;

import junit.framework.JUnit4TestAdapter;

import org.jboss.soa.security.opensso.OpenSSOLoginModule;
import org.junit.Test;


/**
 * Unit test for {@link OpenSSOLoginModule}
 * 
 * @author <a href="mailto:dbevenius@redhat.com">Daniel Bevenius</a>
 *
 */
public class OpenSSOLoginModuleTest
{
	private Subject subject = new Subject();
	
	@Test ( expected = NullPointerException.class )
	public void initializeNullOptionsMap()
	{
		OpenSSOLoginModule loginModule = new OpenSSOLoginModule();
		loginModule.initialize(subject, null, null, null);
	}
	
	@Test 
	public void initialize()
	{
		final Map<String,Object> options = getValidOptions();
		OpenSSOLoginModule loginModule = new OpenSSOLoginModule();
		loginModule.initialize(subject, null, null, options);
	}
	
	@Test
	public void chooseSubject()
	{
		final Map<String,Object> options = getValidOptions();
		OpenSSOLoginModule loginModule = new OpenSSOLoginModule();
		loginModule.initialize(subject, null, null, options);
		Subject chooseSubject = loginModule.chooseSubject(null);
		assertEquals(subject, chooseSubject);
		
		Subject newSubject = new Subject();
		newSubject.getPrincipals().add(new SSOPrincipal("2121455"));
		chooseSubject = loginModule.chooseSubject(newSubject);
		assertFalse(subject.equals(chooseSubject));
	}
	
	private Map<String,Object> getValidOptions()
	{
		final Map<String,Object> options = new HashMap<String,Object>();
		options.put("orgName", "opensso");
		options.put("moduleName", "logingModule");
		options.put("amPropertiesFile", "/AMConfig.properties");
		return options;
	}
	
	public static junit.framework.Test suite()
	{
		return new JUnit4TestAdapter(OpenSSOLoginModuleTest.class);
	}

}
