/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.quickstart.test;

import junit.framework.Test;

import org.jboss.soa.esb.samples.quickstart.wiretap.test.SendStaticRouterJMSMessage;

/**
 * Test for wiretap quickstart.
 * 
 * @author <a href="mailto:tcunning@redhat.com"></a>
 * @version $Id: $
 */

public class WiretapTest extends AbstractQuickstartTestCase {
	private static final String JMS_MESSAGE = "Wiretap Message";

	public WiretapTest(String name) {
		super(name);
	} /* method */

	public void testStaticRouterMessage() throws Exception {
	    clearMessages() ;
	    sendStaticRouterJMSMessage() ;
	    checkMessages(30000, JMS_MESSAGE, JMS_MESSAGE) ;
	} /* method */

	public void sendStaticRouterJMSMessage() throws Exception {
		SendStaticRouterJMSMessage sm = new SendStaticRouterJMSMessage();
		sm.setupConnection();
		sm.sendAMessage(JMS_MESSAGE);
		sm.stop();
	} /* method */

	public static Test suite() throws Exception {
		return getDeploySetup(WiretapTest.class, "QuickstartMessageStoreServer.sar, Quickstart_wiretap.esb");
	} /* method */

} /* class */
