/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author JBoss Inc.
 */
package org.jboss.soa.esb.quickstart.test;

import java.io.InputStream;

import junit.framework.Test;

import org.jboss.soa.esb.samples.quickstart.transformxml2pojo.test.SendJMSMessage;
import org.jboss.soa.esb.testutils.FileUtil;


/**
 * CI test for the transformXML2POJO quickstart.
 *
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 */
public class TransformXML2PojoTest
        extends AbstractQuickstartTestCase
{
	private static final String FILE_NAME = "transformedmessageXML2POJO.log";
	
	public TransformXML2PojoTest(String name)
	{
		super(name);
	}

	public void testMessage() throws Exception
	{
	    clearMessages() ;
	    sendMessage() ;
            final String[] messages = waitForMessages(1, 30000) ;
		// Make sure the file matches expected output
		final InputStream is = getClass().getClassLoader().getResourceAsStream(FILE_NAME) ;
                final String expectedString ;
                try
                {
                    expectedString = FileUtil.readStream(is);
                }
                finally
                {
                    is.close() ;
                }
		final boolean match = Helpers.compareNonXMLContent(expectedString, messages[0], true);
                assertTrue("Unexpected response: " + messages[0], match) ;
	}

	public void sendMessage() throws Exception
	{
		SendJMSMessage sm = new SendJMSMessage();
        sm.setupConnection();
        String fileContent = sm.readAsciiFile(Helpers.getQuickstartLocation("transform_XML2POJO/SampleOrder.xml"));
        System.out.println("FILECONTENT[" + fileContent + "]");
        sm.sendAMessage(fileContent);
        sm.stop();
	}

   public static Test suite() throws Exception
   {
      return getDeploySetup(TransformXML2PojoTest.class, "QuickstartMessageStoreServer.sar, transformation-pojo-quickstart.esb");
   }
}
