package org.jboss.soa.esb.quickstart.test;

import java.io.File;

import junit.framework.Test;
import org.jboss.soa.esb.samples.quickstart.transformxml2pojo2.test.SendJMSMessage;

public class TransformXML2Pojo2Test extends AbstractQuickstartTestCase {
	public TransformXML2Pojo2Test(String name) {
		super(name);
	}

	public void testTransform() throws Exception {
		clearMessages();
		String order = "SampleOrder.xml";
		String orderLocation = Helpers.getQuickstartLocation("transform_XML2POJO2" + File.separator + order);
		SendJMSMessage sm = new SendJMSMessage();
		sm.setupConnection();
		String orderContent = sm.readAsciiFile(orderLocation);
		System.out.println(orderContent);
		sm.sendAMessage(orderContent);
		sm.closeConnection();
		
		clearMessages();
		String petsOrder = "SamplePetsOrder.xml";
		String petsOrderLocation = Helpers.getQuickstartLocation("transform_XML2POJO2" + File.separator + petsOrder);
		SendJMSMessage sjm = new SendJMSMessage();
		sjm.setupConnection();
		String petsOrderContent = sjm.readAsciiFile(petsOrderLocation);
		System.out.println(petsOrderContent);
		sjm.sendAMessage(petsOrderContent);
		sjm.closeConnection();
	}
	
	public static Test suite() throws Exception {
		return getDeploySetup(TransformXML2Pojo2Test.class, "QuickstartMessageStoreServer.sar, Quickstart_transform_XML2POJO2.esb");
	}	
}
