/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.quickstart.test;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

import junit.framework.Test;

/**
 * CI test for the helloworldsqlaction quickstart.
 * 
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 */
public class HelloWorldSQLActionTest extends AbstractQuickstartTestCase {
	
	public HelloWorldSQLActionTest(String name) {
		super(name);
	}

	public void testMessage() throws Exception {
	    fail("Not supported yet") ;
		sendMessage();
		
		// Commented out 20070824 - ldimaggi - the log file is not
		// being written - not clear why - perhaps due to 
		// ESB supports DB as a transport - That type of transport does 
		// not support MySQL
		
//		/* Verify that the message file is created */
//		boolean fileExists = Helpers.checkForFile(LOG_FILE);
//		if (!fileExists) {
//			fail("Event file " + LOG_FILE
//					+ " not created - test marked as failing");
//		}
//
//		/* Verify that the message file is complete */
//		boolean fileComplete = Helpers.checkFileContent(LOG_FILE,
//				EXPECTED_RECORD_COUNT);
//		if (!fileComplete) {
//			Hashtable temp = Helpers.getMessageString(LOG_FILE);
//			File target = new File(LOG_FILE);
//			target.delete();
//			fail("Event file " + LOG_FILE + " not complete - expected "
//					+ EXPECTED_RECORD_COUNT + " records - found " + temp.size()
//					+ ", test marked as failing");
//		}
//
//		Hashtable theTable = Helpers.getMessageString(LOG_FILE);
//		String theMessage = (String) theTable.get("Message1");
//		assertEquals("The strings should match", theMessage, JMS_MESSAGE);
//		File target = new File(LOG_FILE);
//		target.delete();
		
	}

	public void sendMessage() throws Exception {

		Connection connection = null;
		try {
			// Load the JDBC driver
			String driverName = "org.gjt.mm.mysql.Driver";
			Class.forName(driverName);

			// Create a connection to the database
			String serverName = "localhost";
			String mydatabase = "test_sql_gateway";
			String url = "jdbc:mysql://" + serverName + "/" + mydatabase;
			String username = "root";
			String password = "";
			connection = DriverManager.getConnection(url, username, password);
		} catch (ClassNotFoundException e) {
			// Could not find the database driver
		} catch (SQLException e) {
			// Could not connect to the database
		}

		Vector<String> theRecords = new Vector<String>();
		
		String tempStr = "insert into gateway_table values(0,'data 111111','p')";
		theRecords.add(tempStr);

		tempStr = "insert into gateway_table values(0,'data 22','p')";
		theRecords.add(tempStr);

		tempStr = "insert into gateway_table values(0,'data 333333333333111111','p')";
		theRecords.add(tempStr);

		tempStr = "insert into gateway_table values(0,'data d d d d','p')";
		theRecords.add(tempStr);

		tempStr = "insert into gateway_table values(0,'data data last record','p')";
		theRecords.add(tempStr);

		for (int i = 0; i < theRecords.size(); i++) {

			try {
				Statement stmt = connection.createStatement();
				String sql = (String) theRecords.elementAt(i);
				stmt.executeUpdate(sql);
			} catch (SQLException e) {
			}
		}

	} /* method */

	public static Test suite() throws Exception {
		return getDeploySetup(HelloWorldSQLActionTest.class,
				"QuickstartMessageStoreServer.sar, Quickstart_helloworld_SQL_action.esb");
	}/* method */

} /* class */
