/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.quickstart.test;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;

import junit.framework.Test;

/**
 * CI test for the helloworldfileaction quickstart.
 *
 * @author <a href="mailto:tcunning@redhat.com">Tom Cunningham</a>
 */
public class HelloWorldFileActionTest
        extends AbstractQuickstartTestCase {
        
    	private static final String INPUT_DIRECTORY = "helloworld_file_action/build/dirs/input/";
        private static final String INPUT_FILE_NAME = "MyInput.dat";
       	private static final String FILE_CONTENTS = "Hello World In A File";       
        private static final String RESPONSE_CONTENTS = "\nBEFORE\n"+FILE_CONTENTS+"\nAFTER\n";       

	public HelloWorldFileActionTest(String name)
	{
		super(name);
	}

	public void testMessage() throws Exception
	{
	    clearMessages() ;
            createFileAction();
            checkMessages(30000, RESPONSE_CONTENTS) ;
	} /* method */

	public void createFileAction() throws Exception
	{
		final String inputDirectory = Helpers.getQuickstartLocation(INPUT_DIRECTORY) ;
    	File x = new File(inputDirectory, INPUT_FILE_NAME);
    		BufferedWriter out = new BufferedWriter(new FileWriter(x));
    		out.write(FILE_CONTENTS);
    		out.close();
	} /* method */

   public static Test suite() throws Exception
   {
      return getDeploySetup(HelloWorldFileActionTest.class, "QuickstartMessageStoreServer.sar, Quickstart_helloworld_file_action.esb");
   } /* method */
   
} /*/class */
