/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.server.jbpmLocal;

import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;

import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.soa.esb.server.RedeliveryMBean;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;

/**
 * Action Handler for jBPM local test.
 */
public class JbpmLocalLogHandler implements ActionHandler
{
    /**
     * Serial version UID for this class.
     */
    private static final long serialVersionUID = -2640937298056584812L;

    /**
     * Wait for a notification from the test.
     */
    public void execute(final ExecutionContext executionContext)
        throws Exception
    {
        final ContextInstance contextInstance = executionContext.getContextInstance() ;
        final Token token = executionContext.getToken() ;
        final Object value = contextInstance.getVariable("theBody", token) ;
        
        getRedeliveryMBean().logMessage(String.valueOf(value)) ;
    }
    
    private RedeliveryMBean getRedeliveryMBean()
        throws MalformedObjectNameException
    {
        final MBeanServer server = MBeanServerLocator.locateJBoss();
        
        return (RedeliveryMBean) MBeanProxyExt.create(RedeliveryMBean.class, RedeliveryMBean.objectName, server);
    }
}
