/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.soa.esb.server.jbpmAsync;

import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;

import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.soa.esb.actions.AbstractActionLifecycle;
import org.jboss.soa.esb.actions.ActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;

/**
 * Action class to attempt a suspend of a running jBPM process.
 * 
 * @author <a href='mailto:Kevin.Conner@jboss.com'>Kevin Conner</a>
 */
public class EchoSuspendAction extends AbstractActionLifecycle implements ActionPipelineProcessor
{
    public EchoSuspendAction(final ConfigTree config)
    {
    }

    public Message process(final Message message)
        throws ActionProcessingException
    {
        final MBeanServer server = MBeanServerLocator.locateJBoss();
        
        final JbpmServerMBean jbpmServer ;
        try
        {
            jbpmServer = (JbpmServerMBean) MBeanProxyExt.create(JbpmServerMBean.class, JbpmServerMBean.OBJECT_NAME, server);
        }
        catch (final MalformedObjectNameException mone)
        {
            throw new ActionProcessingException("Error creating MBean proxy", mone) ;
        }
        jbpmServer.suspendProcessInstance() ;
        return message;
    }
    
    public void processException(final Message message, final Throwable th)
    {
    }
    
    public void processSuccess(final Message message)
    {
    }
}
