/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.soa.esb.server.epr;

import junit.framework.Test;
import org.jboss.soa.esb.TestUtils;
import org.jboss.soa.esb.addressing.eprs.LogicalEPR;

import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;

import javax.management.Attribute;
import javax.management.ObjectName;

import junit.framework.Test;
import org.jboss.soa.esb.testutils.JMSUtil;

import org.jboss.soa.esb.common.tests.BaseTest;
import org.jboss.soa.esb.server.EPRStorage;
import org.jboss.soa.esb.server.EPRStorageMBean;
import org.jboss.test.JBossTestCase;

/**
 * Sample client for the jboss container.
 *
 * @author <a href="mailto:bill@burkecentral.com">Bill Burke</a>
 * @version $Id: BlobUnitTestCase.java 58110 2006-11-04 08:34:21Z scott.stark@jboss.org $
 */

public class LogicalEPRUnitTest
        extends JBossTestCase
{
   public LogicalEPRUnitTest(String name)
   {
      super(name);
   }

   public void testJMX() throws Exception
   {
      //Thread.sleep(10000); // wait for message to post.
      Attribute attr = new Attribute("Message", "foo");
      getServer().setAttribute(new ObjectName(EPRStorageMBean.objectName), attr);
      String version = (String)getServer().getAttribute(new ObjectName(EPRStorageMBean.objectName), "Message");
      assertEquals("foo", version);      
   }

    public void test_replyto() throws Exception {
	ObjectName on = new ObjectName(EPRStorageMBean.objectName);
	getServer().invoke(on, "clearMessage", null, null);

        // Send the message and wait for the drop...
        JMSUtil.sendMessageToQueue("reply-To", "queue/LogicalEPRUnitTest_service1_gtw", null);
	Thread.sleep(10000);
      	String messageOutput = (String) getServer().getAttribute(on, "Message");
        System.out.println("value from JMX = " + messageOutput);

        assertEquals("Reply-To Service3", messageOutput);
    }

    public void test_faultto() throws Exception {
	ObjectName on = new ObjectName(EPRStorageMBean.objectName);
	getServer().invoke(on, "clearMessage", null, null);

        // Send the message and wait for the drop...
        JMSUtil.sendMessageToQueue("fault-To", "queue/LogicalEPRUnitTest_service1_gtw", null);
	Thread.sleep(10000);
	String messageOutput = (String) getServer().getAttribute(on, "Message");
	System.out.println("value from JMX = " + messageOutput);
        assertEquals("org.jboss.soa.esb.actions.ActionProcessingException: Service2Action fault", messageOutput);
    }

    public void test_logical_extension() throws Exception {
	ObjectName on = new ObjectName(EPRStorageMBean.objectName);
	getServer().invoke(on, "clearMessage", null, null);

        final LogicalEPR logicalEPR = new LogicalEPR("MyServiceCategory", "MyService4") ;
        final String tag = "TestTag" ;
        final String prefix = "TestPrefix" ;
        final String value = "TestValue" ;
        
        logicalEPR.getAddr().addExtension(tag, prefix, Service4Action.TEST_URI, value) ;
        
        final Message message = MessageFactory.getInstance().getMessage() ;
        message.getBody().add("Incoming Test Payload") ;
        logicalEPR.getServiceInvoker().deliverAsync(message) ;
	Thread.sleep(10000);
        String messageOutput = (String) getServer().getAttribute(on, "Message"); 
        System.out.println("value from JMX = " + messageOutput);
 
        final String expectedOutput = "Prefix " + prefix + " Tag " + tag + " value " + value ;
        assertEquals(expectedOutput, messageOutput);
    }



   public static Test suite() throws Exception
   {
       return getDeploySetup(LogicalEPRUnitTest.class, "epr-test.esb");
   }
}
