/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.soa.esb.server.ebws;

import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;

import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;

/**
 * EBWS Utility methods and constants.
 *
 * @author <a href="kevin.conner@jboss.com">Kevin Conner</a>
 */
public class EBWSUtil
{
    public static final String VALID_REQUEST = "<say:sayHi xmlns:say=\"http://www.jboss.org/sayHi\"><say:arg0>Hello</say:arg0></say:sayHi>" ;
    public static final String INVALID_REQUEST = "<say:sayHi xmlns:say=\"http://www.jboss.org/sayHiInvalid\"><say:arg0>Hello</say:arg0></say:sayHi>" ;
    public static final String VALID_RESPONSE = "<say:sayHiResponse xmlns:say=\"http://www.jboss.org/sayHi\"><say:arg0>Hello Response</say:arg0></say:sayHiResponse>" ;
    public static final String INVALID_RESPONSE = "<say:sayHiResponse xmlns:say=\"http://www.jboss.org/sayHiInvalid\"><say:arg0>Hello Response</say:arg0></say:sayHiResponse>" ;

    public static final String REQUEST_LOCATION = "REQUEST_LOCATION" ;
    public static final String RESPONSE_LOCATION = "RESPONSE_LOCATION" ;
    public static final String NORMAL_SERVICE = "normal" ;
    public static final String ALTERNATE_SERVICE = "alternate" ;
    public static final String ERROR = "ERROR" ;
    
    public static final String SOAP_REQUEST = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">" +
            "<soap:Body>" + VALID_REQUEST + "</soap:Body></soap:Envelope>" ; 

    public static final String SOAP_RESPONSE = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">" +
            "<soap:Header/><soap:Body>" + VALID_RESPONSE + "</soap:Body></soap:Envelope>" ;
    
    public static final String SOAP_ADDRESSING_REQUEST = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">" +
        "<soap:Header xmlns:wsa=\"http://www.w3.org/2005/08/addressing\">" +
            "<wsa:MessageID>urn:esb:1234567</wsa:MessageID>" +
            "<wsa:To>http://example.com/To</wsa:To>" +
            "<wsa:Action>http://soa.jboss.org/TestEBWS/addressingOp</wsa:Action>" +
        "</soap:Header>" +
        "<soap:Body>" + VALID_REQUEST + "</soap:Body></soap:Envelope>" ; 

    public static final String SOAP_ADDRESSING_RESPONSE = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">" +
            "<soap:Header/><soap:Body>" + VALID_RESPONSE + "</soap:Body></soap:Envelope>" ;

    public static final String NORMAL_SOAP_ENDPOINT = "http://127.0.0.1:8080/ebws-test/ebws/TestEBWS/normal" ;
    public static final String ALTERNATE_SOAP_ENDPOINT = "http://127.0.0.1:8080/ebws-test/ebws/TestEBWS/alternate" ; 
    public static final String NORMAL_SOAP_ADDRESSING_ENDPOINT = "http://127.0.0.1:8080/ebws-test/ebws/TestEBWS/addressing" ; 
    
    public static EBWSServerMBean getEBWSServerMBean()
        throws MalformedObjectNameException
    {
        final MBeanServer server = MBeanServerLocator.locateJBoss();
        
        return (EBWSServerMBean) MBeanProxyExt.create(EBWSServerMBean.class, EBWSServerMBean.OBJECT_NAME, server);
    }
}
