/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.soa.esb.server;

import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;

import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.soa.esb.actions.AbstractActionLifecycle;
import org.jboss.soa.esb.actions.ActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.lifecycle.LifecycleResourceManager;
import org.jboss.soa.esb.message.Message;

/**
 * Action class to force a redelivery for the first message.
 * @author kevin
 */
public class MyRedeliveryAction extends AbstractActionLifecycle implements ActionPipelineProcessor
{
    private int count ;
    
    public MyRedeliveryAction(final ConfigTree config)
    {
    }

    public Message process(Message message) throws ActionProcessingException
    {
        final String incomingMessage = (String) message.getBody().get() ;
        
        System.out.println("\n&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
        System.out.println("Body: " + incomingMessage) ;
        System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&\n");
        
        if (LifecycleResourceManager.DEFAULT_IDENTITY.equals(LifecycleResourceManager.getSingleton().getIdentity()))
        {
            getRedeliveryMBean().logMessage("Default lifecycle identity used by JCA");
        }
        else
        {
            getRedeliveryMBean().logMessage(incomingMessage);
        }
        // Throw an error every second message
        if ((count++ & 1) == 0)
        {
            throw new IllegalArgumentException("An error to force redelivery") ;
        }
        return message;
    }
    
    public void processException(final Message message, final Throwable th)
    {
        final String incomingMessage = (String) message.getBody().get() ;
        try
        {
            getRedeliveryMBean().logMessage("Exception for message " + incomingMessage + ":" + th.getMessage());
        }
        catch (final ActionProcessingException ape)
        {
            System.out.println("Caught action processing exception: " + ape) ;
        }
    }
    
    public void processSuccess(final Message message)
    {
        final String incomingMessage = (String) message.getBody().get() ;
        try
        {
            getRedeliveryMBean().logMessage("Success for message " + incomingMessage);
        }
        catch (final ActionProcessingException ape)
        {
            System.out.println("Caught action processing exception: " + ape) ;
        }
    }
    
    private RedeliveryMBean getRedeliveryMBean()
        throws ActionProcessingException
    {
        final MBeanServer server = MBeanServerLocator.locateJBoss();
        
        try
        {
            return (RedeliveryMBean) MBeanProxyExt.create(RedeliveryMBean.class, RedeliveryMBean.objectName, server);
        }
        catch (final MalformedObjectNameException mone)
        {
            throw new ActionProcessingException("Error creating MBean proxy", mone) ;
        }
    }
}
