/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.jms;

import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.apache.log4j.Logger;

import java.io.File;
import java.io.IOException;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class TargetServiceAction extends AbstractActionPipelineProcessor {

    public static final String FILE_PREFIX = "TargetServiceAction-";
    private static Logger logger = Logger.getLogger(TargetServiceAction.class);
    private static String buildDir = System.getProperty("build.dir");

    public TargetServiceAction(ConfigTree config) {
    }

    public Message process(final Message message) throws ActionProcessingException {
        String addition = (String) message.getProperties().getProperty("addition");
        File buildDirFile = new File(buildDir);

        if(!buildDirFile.exists()) {
            throw new ActionProcessingException("Invalid 'build.dir' dir '" + buildDirFile.getAbsolutePath() + "'.");
        }

        File file = new File(buildDirFile, FILE_PREFIX + addition);
        try {
            logger.info("Creating file " + file.getAbsolutePath());
            file.createNewFile();
        } catch (IOException e) {
            throw new ActionProcessingException("Failed to create file '" + file.getAbsolutePath() + "'.");
        }

        return message;
    }
}
