/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author JBoss Inc.
 */

package org.jboss.soa.esb;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.ArrayList;

/**
 * Helper class for tests.
 * <p/>
 * Just a few methods lifted from the quickstart "Helper" class.
 */
public class TestUtils {

	/* Determine if the event file has been written */
	public static boolean waitForFile(String fileName) throws Exception {
		final File file = new File(fileName) ;

        long startTime = System.currentTimeMillis();
        while(System.currentTimeMillis() < startTime + 30000) {
            if(file.exists()) {
                return true;
            }
            Thread.sleep(500);
        }

        return false;
    }

    public static String getTempDir(String filename)
    {
        String tmpDir="";
        if (!filename.startsWith(File.separator)) {
            tmpDir = System.getProperty("java.io.tmpdir") + File.separator;
        }
        return tmpDir;
    }

    public static String getQuickstartLocation(final String location)
        throws IOException
    {
        final File quickstartDir = new File(System.getProperty("org.jboss.esb.test.quickstarts.dir"), location) ;
        return quickstartDir.getCanonicalPath() ;
    }

    public static boolean assertEquals(final String content1, final String content2, final boolean trimLines) throws IOException {
        List<String> content1Lines = getLines(content1, trimLines);
        List<String> content2Lines = getLines(content2, trimLines);

        return content1Lines.equals(content2Lines);
    }

    private static List<String> getLines(final String string, final boolean trimLines) throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(string));
        List<String> lines = new ArrayList<String>();
        String line;

        while((line = reader.readLine()) != null) {
            if(trimLines) {
                lines.add(line.trim());
            } else {
                lines.add(line);
            }
        }

        return lines;
    }
}