package org.jbosson.plugins.jbossesb;

import java.util.Hashtable;

import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.MBeanResourceComponent;

/**
 * Abstract class which gets version attributes.
 *
 * @author Tom Cunningham
 * @param <T>
 */
public abstract class SOADiscoveryComponent implements ResourceDiscoveryComponent<MBeanResourceComponent>  {
	public static final String SYSTEM_BEAN = "jboss.system:type=Server";
	public static final String VERSION_NUMBER = "VersionNumber";
	public static final String BUILD_DATE = "BuildDate";
	public static final String BUILD_ID = "BuildID";
	
	public Hashtable getVersionAttribute(ResourceDiscoveryContext<MBeanResourceComponent> context) {
	    Hashtable ht = new Hashtable();

		try {
			EmsBean bean = context.getParentResourceComponent().getEmsConnection().getBean(SYSTEM_BEAN);
		    EmsAttribute versionAttribute = bean.getAttribute(VERSION_NUMBER);		
		    String version = (String) versionAttribute.refresh();
		    
		    EmsAttribute buildDateAttribute = bean.getAttribute(BUILD_DATE);
		    String buildDate = (String) buildDateAttribute.refresh();
	
		    EmsAttribute buildIDAttribute = bean.getAttribute(BUILD_ID);
		    String buildID = (String) buildIDAttribute.refresh();
	
		    ht.put(VERSION_NUMBER, version);
		    ht.put(BUILD_DATE, buildDate);
		    ht.put(BUILD_ID, buildID);
		} catch (Exception e) {
			// Do nothing in the case that we cannot recover these attributes
		}
	    return ht;
	}
}
