/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbosson.plugins.jbossesb;

import org.rhq.core.domain.event.Event;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.pluginapi.event.EventPoller;

import javax.management.*;
import javax.management.remote.*;
import java.util.Iterator;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

import org.rhq.core.domain.event.Event;
import org.rhq.core.domain.event.EventSeverity;

import org.rhq.core.pluginapi.event.EventPoller;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;

import org.rhq.core.pluginapi.inventory.ResourceContext;

import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.support.classloader.ClassLoaderFactory;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.mc4j.ems.connection.bean.notification.EmsNotification;
import org.mc4j.ems.connection.bean.notification.EmsNotificationEvent;
import org.mc4j.ems.connection.bean.notification.EmsNotificationListener;
import org.mc4j.ems.connection.bean.operation.EmsOperation;

/**
 * Message event poller.      Grabs notifications from the MessageAlerts MBean and 
 * converts them into Events.     Clears the MessageAlerts ArrayList after collecting 
 * the notifications.
 * 
 * A better implementation of this would use EmsNotification, but EmsNotifications do
 * not seem to add a listener and collect Notifications properly.
 * 
 * @author <a href="mailto:tcunning@redhat.com">tcunning@redhat.com</a> 
 */
public class ESBMessageEventPoller implements EventPoller {
	public static final String SERVICE_LENGTH_NOTIFICATION_TYPE = "org.jboss.esb.message.service.length.alert";
	public static final String SERVICE_TIME_NOTIFICATION_TYPE = "org.jboss.esb.message.service.time.alert";
	public static final String ACTION_LENGTH_NOTIFICATION_TYPE = "org.jboss.esb.message.action.length.alert";
	public static final String ACTION_TIME_NOTIFICATION_TYPE = "org.jboss.esb.message.action.time.alert";

	public static final String MESSAGE_ALERTS_BEAN = "jboss.esb:service=MessageAlerts";
	public static final String ALERTS_ATTRIBUTE = "Alerts";
	public static final String CLEAR_ALERT_OPERATION = "clearAlerts";
	   
	private static final String NOTIFICATION_MESSAGE = "notificationMessage";
	private static final String NOTIFICATION_SOURCE = "notificationSource";
	private static final String NOTIFICATION_SEQUENCE_LONG = "notificationSequence";
	private static final String NOTIFICATION_TIMESTAMP_LONG = "notificationTimestamp";
	private static final String NOTIFICATION_TYPE = "notificationType";

	   
	private final Set<Event> events = new HashSet<Event>();
	private String eventType;
	private EmsBean emsbean;
	private EmsConnection connection;
	   
	 /**
	  * Constructor
	 * @param eventType
	 */
	public ESBMessageEventPoller(String eventType) {
	      this.eventType = eventType;
	      emsbean = null;
	      connection = null;
	   }	    

	 /**
	 * Set the Ems connection and grab the emsbean.
	 * @param connection
	 */
	public boolean setConnection(EmsConnection connection) {
		this.connection = connection;
		this.emsbean = connection.getBean(MESSAGE_ALERTS_BEAN);
		return (emsbean != null) ;
	}
	   
	/** Return the type of events we handle
	* @see org.rhq.core.pluginapi.event.EventPoller#getEventType()
	*/
	public String getEventType() {
		return eventType;
	}

	/** Return collected events
	* @see org.rhq.core.pluginapi.event.EventPoller#poll()
	*/
	public synchronized Set<Event> poll() {
		if (emsbean != null) {
    		try {
    			EmsAttribute alertAttribute = emsbean.getAttribute(ALERTS_ATTRIBUTE);
    			if (alertAttribute != null) {
    				Vector<Hashtable> notifList = null;
	    			notifList = (Vector<Hashtable>) alertAttribute.refresh();
					for (Hashtable notifHash : notifList) {
				    	long timestamp = (new Long ((String) notifHash.get(NOTIFICATION_TIMESTAMP_LONG))).longValue();
					    	
				    	Event event = new Event(getEventType(), 
								((String)notifHash.get(NOTIFICATION_TYPE)),
								timestamp,
								EventSeverity.WARN,
								((String)notifHash.get(NOTIFICATION_MESSAGE)));
				    	EmsOperation clear = emsbean.getOperation(CLEAR_ALERT_OPERATION);
				    	clear.invoke();
				    	events.add(event);
				    }
   				}
   			} catch (Exception e) {
   				e.printStackTrace();
   			} 
   		}
    	return events;
    }
}
