/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.services.soapui;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.*;

import javax.xml.transform.stream.StreamResult;

import junit.framework.TestCase;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.http.HttpClientFactory;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class JBESB_2451_SoapUIClientServiceMBeanUnitTest extends TestCase {

    private static final String WSDL_LOCATAION = "src/test/java/org/jboss/soa/esb/services/soapui";
    private Properties properties;

    protected void setUp() throws Exception {
        properties = new Properties();
    }

    public void test_single() throws IOException, SAXException, ConfigurationException {
        HashMap requestMap = new HashMap();
        Order[] orders = new Order[1];

        Order order = new Order();
        order.setId((long)1);
        order.setShipTo("Hokkaido");

        LineItem lineItem1 = new LineItem();
        lineItem1.setId((long)1);
        lineItem1.setName("aname");
        lineItem1.setPrice((float)10.00);

        LineItem lineItem2 = new LineItem();
        lineItem2.setId((long)2);
        lineItem2.setName("aname2");
        lineItem2.setPrice((float)20.00);

        ArrayList lineItems = new ArrayList();
        lineItems.add(lineItem1);
        lineItems.add(lineItem2);

        order.setLineItems(lineItems);

        orders[0] = order;

        ProcessOrderRequest requestObject = new ProcessOrderRequest();
        requestObject.setOrder(orders);
        requestMap.put("processOrder", requestObject);

        test(requestMap, "expected_JBESB_2451_01.xml");
    }

    public void test_multiple() throws IOException, SAXException, ConfigurationException {
        HashMap requestMap = new HashMap();
        Order[] orders = new Order[2];

        Order order = new Order();
        order.setId((long)1);
        order.setShipTo("Hokkaido");

        LineItem lineItem1 = new LineItem();
        lineItem1.setId((long)1);
        lineItem1.setName("aname");
        lineItem1.setPrice((float)10.00);

        LineItem lineItem2 = new LineItem();
        lineItem2.setId((long)2);
        lineItem2.setName("aname2");
        lineItem2.setPrice((float)20.00);

        ArrayList lineItems = new ArrayList();
        lineItems.add(lineItem1);
        lineItems.add(lineItem2);

        order.setLineItems(lineItems);

        Order order2 = new Order();
        order2.setId((long)2);
        order2.setShipTo("Okinawa");

        LineItem lineItem3 = new LineItem();
        lineItem3.setId((long)3);
        lineItem3.setName("aname3");
        lineItem3.setPrice((float)30.00);

        LineItem lineItem4 = new LineItem();
        lineItem4.setId((long)4);
        lineItem4.setName("aname4");
        lineItem4.setPrice((float)40.00);

        ArrayList lineItems2 = new ArrayList();
        lineItems2.add(lineItem3);
        lineItems2.add(lineItem4);

        order2.setLineItems(lineItems2);

        orders[0] = order;
        orders[1] = order2;

        ProcessOrderRequest requestObject = new ProcessOrderRequest();
        requestObject.setOrder(orders);
        requestMap.put("processOrder", requestObject);

        test(requestMap, "expected_JBESB_2451_02.xml");
    }

    public void test(Map params, String expected) throws IOException, SAXException, ConfigurationException {
    	File wsdlFile = new File(WSDL_LOCATAION + "/JBESB_2451.wsdl");
        SoapUIClientService mbean = new SoapUIClientService();

        properties.setProperty(HttpClientFactory.TARGET_HOST_URL, wsdlFile.toURI().toString());

        params.put("dumpSOAP", true);

        String message = mbean.buildRequest(wsdlFile.toURI().toString(), "processOrder", null, params, properties, null, null);
        assertTrue("Generated SOAP message not as expected. See " + expected + ".  Generated message: \n" + message, compareCharStreams(getClass().getResourceAsStream(expected), new ByteArrayInputStream(message.getBytes())));
    }

    // Lifted from milyn commons
    public static boolean compareCharStreams(InputStream s1, InputStream s2) {
        try {
            final String xml1 = trimLines(s1).toString() ;
            final String xml2 = trimLines(s2).toString() ;

            final Document doc1 = YADOMUtil.parse(xml1) ;
            final Document doc2 = YADOMUtil.parse(xml2) ;

            final StringWriter writer1 = new StringWriter() ;
            final StringWriter writer2 = new StringWriter() ;
            YADOMUtil.serialize(doc1, new StreamResult(writer1)) ;
            YADOMUtil.serialize(doc2, new StreamResult(writer2)) ;
            return (writer1.toString().equals(writer2.toString())) ;
        } catch (IOException e) {
            // fail the comparison
        } catch (SAXException e) {
            // fail the comparison
        } catch (ConfigurationException e) {
            // fail the comparison
        }

        return false;
    }
    public static StringBuffer trimLines(InputStream charStream) throws IOException {
        StringBuffer stringBuf = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(charStream));
        String line;

        while((line = reader.readLine()) != null) {
            stringBuf.append(line.trim());
        }

        return stringBuf;
    }
}