/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.services.soapui;

import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlLoader;

import java.io.InputStream;
import java.io.ByteArrayInputStream;
import java.net.URL;

import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;

/**
 * {@link WsdlLoader} implementation that gets injected into soapUI.
 *
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
class EsbWsdlLoader extends WsdlLoader {

    private static Logger logger = Logger.getLogger(EsbWsdlLoader.class);

    private boolean isAborted = false;
    private HttpClient httpClient;
    
    public EsbWsdlLoader(String url, HttpClient httpClient) {
        super(url);
        this.httpClient = httpClient;
    }

    public InputStream load(String url) throws Exception {
        GetMethod httpGetMethod;

        if(url.startsWith("file")) {
            return new URL(url) .openStream();
        }

        // Authentication is not being overridden on the method.  It needs
        // to be present on the supplied HttpClient instance!
        httpGetMethod = new GetMethod(url);
        httpGetMethod.setDoAuthentication(true);

        //JBESB-3275 - a transparent proxy might close connections
        httpGetMethod.setRequestHeader("Connection", "keep-alive");

        try {
            int result = httpClient.executeMethod(httpGetMethod);

            if(result != HttpStatus.SC_OK) {
                if(result < 200 || result > 299) {
                    throw new HttpException("Received status code '" + result + "' on WSDL HTTP (GET) request: '" + url + "'.");
                } else {
                    logger.warn("Received status code '" + result + "' on WSDL HTTP (GET) request: '" + url + "'.");
                }
            }

            return new ByteArrayInputStream(httpGetMethod.getResponseBody());
        } finally {
            httpGetMethod.releaseConnection();
        }
    }

    public boolean abort() {
        isAborted = true;
        return true;
    }

    public boolean isAborted() {
        return isAborted;
    }

    public void close() {
        
    }
}
