/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.actions.soap.request;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.ActionLifecycleException;
import org.jboss.soa.esb.actions.soap.SOAPClient;
import org.jboss.soa.esb.actions.soap.SoapUIInvoker;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.services.soapui.SoapUIClientService;
import org.xml.sax.SAXException;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class MockSOAPClient extends SOAPClient {

    public MockSOAPClient(ConfigTree config) throws ConfigurationException {
        super(config);
    }

    public void initialise() throws ActionLifecycleException {
        // intentionally not calling super

        try {
            SoapUIInvoker soapUIInvoker = new SoapUIInvoker() {
                private SoapUIClientService service = new SoapUIClientService();

                public String buildRequest(String wsdl, String operation, String serviceName, Map params, Properties httpClientProps, String smooksResource, String soapNs) throws IOException, UnsupportedOperationException, SAXException {
                    return service.buildRequest(wsdl, operation, null, params, httpClientProps, smooksResource, soapNs);
                }

                public String buildResponse(String wsdl, String operation, String serviceName, Map params, Properties httpClientProps, String smooksResource, String soapNs) throws IOException, UnsupportedOperationException, SAXException {
                    return service.buildResponse(wsdl, operation, null, params, httpClientProps, smooksResource, soapNs) ;
                }

                public String buildFault(String wsdl, String operation, String serviceName, String faultName, Map params, Properties httpClientProps, String smooksResource, String soapNs) throws IOException, UnsupportedOperationException, SAXException {
                    return service.buildFault(wsdl, operation, null, faultName, params, httpClientProps, smooksResource, soapNs) ;
                }

                public String getEndpoint(String wsdl, String serviceName, Properties httpClientProps) throws IOException {
                    return service.getEndpoint(wsdl, serviceName, httpClientProps);
                }

                public String getContentType(String wsdl, String serviceName, Properties httpClientProps) throws IOException {
                    return service.getContentType(wsdl, serviceName, httpClientProps);
                }

                public String mergeResponseTemplate(String wsdl, String operation, String serviceName, String response, Properties httpClientProps, String smooksResource, String soapNs) throws IOException, UnsupportedOperationException, SAXException {
                    return service.mergeResponseTemplate(wsdl, operation, null, response, httpClientProps, smooksResource, soapNs);
                }
            };
            
            setSoapUIInvoker(soapUIInvoker);
        } catch (ConfigurationException e) {
            throw new ActionLifecycleException("Failed to initialize SoapUIInvoker.", e);
        }
    }
}
