/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */

package org.jboss.soa.esb.actions.soap.adapter.wsnative;

import javax.servlet.ServletContext;

import org.jboss.soa.esb.actions.soap.adapter.SOAPProcessorFactory;
import org.jboss.soa.esb.actions.soap.adapter.SOAPProcessorServletContext;
import org.jboss.wsf.spi.deployment.Endpoint;

/**
 * Factory for creating JBossWS native specific proxies.
 *  
 * @author <a href="mailto:kevin.conner@jboss.com">Kevin Conner</a>
 */
public class JBossWSNativeFactory extends SOAPProcessorFactory
{
    public ServletContext createServletContext(final Endpoint endpoint)
    {
        return new SOAPProcessorServletContext() ;
    }
}
