/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */

package org.jboss.soa.esb.actions.soap.adapter.cxf;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;

import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

import org.apache.cxf.transport.servlet.ServletController;
import org.jboss.wsf.spi.deployment.Endpoint;

/**
 * This is an adapter used when integrating with JBossWS CXF integration.
 *  
 * @author <a href="mailto:kevin.conner@jboss.com">Kevin Conner</a>
 */
public class SOAPProcessorCXFServletContext implements ServletContext
{
    private static final String CONTROLLER_NAME = ServletController.class.getName() ;
    
    private final Endpoint endpoint ;
    
    private ServletControllerExtProvider provider ;
    
    public SOAPProcessorCXFServletContext(final Endpoint endpoint)
    {
        this.endpoint = endpoint ;
    }
    
    private synchronized ServletControllerExtProvider getProvider()
    {
        if (provider == null)
        {
            provider = ServletControllerExtProviderFactory.getFactory(endpoint, this) ;
        }
        return provider ;
    }
    
    public Object getAttribute(final String name)
    {
        if (CONTROLLER_NAME.equals(name))
        {
            return getProvider().getServletControllerExt() ;
        }
        else
        {
            throw new UnsupportedOperationException("Not yet supported") ;
        }
    }

    public Enumeration getAttributeNames()
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public ServletContext getContext(final  String name)
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public String getInitParameter(final String param)
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public Enumeration getInitParameterNames()
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public int getMajorVersion()
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public int getMinorVersion()
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public String getMimeType(final String file)
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public RequestDispatcher getNamedDispatcher(final String name)
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public String getRealPath(final String path)
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public RequestDispatcher getRequestDispatcher(final String path)
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public URL getResource(final String path)
        throws MalformedURLException
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public InputStream getResourceAsStream(final String path)
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public Set getResourcePaths(final String path)
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public String getServerInfo()
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public Servlet getServlet(final String name)
        throws ServletException
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public String getServletContextName()
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public Enumeration getServletNames()
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public Enumeration getServlets()
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public void log(final String msg)
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public void log(final Exception ex, final String msg)
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public void log(final String msg, final Throwable th)
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public void removeAttribute(final String name)
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public void setAttribute(final String name, final Object value)
    {
        throw new UnsupportedOperationException("Not yet supported") ;
    }

    public String getContextPath()
    {
//        return "" ;
        throw new UnsupportedOperationException("Not yet supported") ;
    }
}
