package org.jboss.soa.esb.actions.soap;

import org.xml.sax.SAXException;

import java.util.Map;
import java.util.Properties;
import java.io.IOException;

/**
 * @author
 */
public interface SoapUIInvoker {
    String buildRequest(String wsdl, String operation, String serviceName, Map params, Properties httpClientProps, String smooksResource, String soapNs) throws IOException, UnsupportedOperationException, SAXException;
    
    String buildResponse(String wsdl, String operation, String serviceName, Map params, Properties httpClientProps, String smooksResource, String soapNs) throws IOException, UnsupportedOperationException, SAXException;
    
    String buildFault(String wsdl, String operation, String serviceName, String faultName, Map params, Properties httpClientProps, String smooksResource, String soapNs) throws IOException, UnsupportedOperationException, SAXException;

    String getEndpoint(String wsdl, String serviceName, Properties httpClientProps) throws IOException;

    String getContentType(String wsdl, String serviceName, Properties httpClientProps) throws IOException;

    String mergeResponseTemplate(String wsdl, String operation, String serviceName, String response, Properties httpClientProps, String smooksResource, String soapNs) throws IOException, UnsupportedOperationException, SAXException;
}
