/*
 * JBoss, Home of Professional Open Source Copyright 2009, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.actions.soap;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.ws.handler.soap.SOAPMessageContext;

import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.w3c.dom.Element;

/**
 * Util methods for handling SAML related tasks for SOAP Protocol Handlers.
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 * 
 */
public class SOAPSamlHandlerUtil
{
    private static final SOAPFactory SOAP_FACTORY = createSOAPFactory();

    private SOAPSamlHandlerUtil()
    {
    }

    public static SOAPElement addAssertion(final SOAPMessageContext soapContext, final QName securityHeader, final Element assertion) throws SOAPException
    {
        AssertArgument.isNotNull(soapContext, "soapContext");
        AssertArgument.isNotNull(assertion, "assertion");

        final SOAPEnvelope envelope = soapContext.getMessage().getSOAPPart().getEnvelope();
        SOAPHeader header = envelope.getHeader();
        if (header == null)
        {
            header = envelope.addHeader();
        }
        final SOAPElement securityElement = header.addChildElement(securityHeader);
        // Add the assertion element.
        return securityElement.addChildElement(SOAP_FACTORY.createElement(assertion));
    }

    private static SOAPFactory createSOAPFactory()
    {
        try
        {
            return SOAPFactory.newInstance();
        }
        catch (final SOAPException e)
        {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

}
