/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * (C) 2005-2008, JBoss Inc.
 */
package org.jboss.soa.esb.actions.soap;

import org.milyn.delivery.dom.serialize.DefaultSerializationUnit;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Attr;

import java.io.Writer;
import java.io.IOException;

/**
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class DenormalizedAttributeValueSerializer extends DefaultSerializationUnit {

    private StringBuilder denormalizeBuffer = new StringBuilder();

    /**
     * Write the element attributes.
     * @param attributes The element attibutes.
     * @param writer The writer to be written to.
     * @throws IOException Exception writing output.
     */
    protected void writeAttributes(NamedNodeMap attributes, Writer writer) throws IOException {
        int attribCount = attributes.getLength();

        for(int i = 0; i < attribCount; i++) {
            Attr attribute = (Attr)attributes.item(i);
            String attribValue = attribute.getValue();
            int enclosingChar = (int)'"';

            writer.write((int)' ');
            writer.write(attribute.getName());
            writer.write((int)'=');
            if(attribValue.indexOf((int)'"') != -1) {
                enclosingChar = (int)'\'';
            }
            writer.write(enclosingChar);
            writer.write(denormalize(attribValue));
            writer.write(enclosingChar);
        }
    }

    private String denormalize(String attribValue) {
        denormalizeBuffer.setLength(0);

        //
        // Reversing the normalization work done on the attribute values by the
        // parser (http://www.w3.org/TR/2006/REC-xml-20060816/#AVNormalize). Assumption
        // here is that there's no entity/char values in the attribute!!
        //

        for(int i = 0; i < attribValue.length(); i++) {
            char character = attribValue.charAt(i);

            if(character == '<') {
                denormalizeBuffer.append("&lt;");
            } else if(character == '>') {
                denormalizeBuffer.append("&gt;");
            } else if(character == '&') {
                denormalizeBuffer.append("&amp;");
            } else if(character == '\'') {
                denormalizeBuffer.append("&apos;");
            } else if(character == '"') {
                denormalizeBuffer.append("&quot;");
            } else {
                denormalizeBuffer.append(character);
            }
        }

        return denormalizeBuffer.toString();
    }
}
