/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.internal.soa.esb.soap.cxf;

import java.util.Map;

import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.Endpoint;

/**
 * A jbossws deployment aspect that modified the load on startup servlet configuration.
 *
 * @author <a href='mailto:kevin.conner@jboss.com>Kevin Conner</a>
 */
public class LoadOnStartupDeploymentAspect extends DeploymentAspect
{
    private String servletClassProperty ;
    private int loadOnStartup = 1 ;

    public String getServletClassProperty()
    {
       return servletClassProperty ;
    }

    public void setServletClassProperty(final String servletClassProperty)
    {
        this.servletClassProperty = servletClassProperty ;
    }

    public int getLoadOnStartup()
    {
       return loadOnStartup ;
    }

    public void setLoadOnStartup(final int loadOnStartup)
    {
        this.loadOnStartup = loadOnStartup ;
    }
    
    @Override
    public void start(final Deployment dep)
    {
        if (servletClassProperty != null)
        {
            final Object servletClassObj = dep.getProperty(servletClassProperty) ;
            if (servletClassObj != null)
            {
                final String servletClass = servletClassObj.toString() ;
                final JBossWebMetaData webMetaData = dep.getAttachment(JBossWebMetaData.class);
                if (webMetaData != null)
                {
                    final JBossServletsMetaData servlets = webMetaData.getServlets() ;
                    if (servlets != null)
                    {
                        for(JBossServletMetaData servlet : servlets)
                        {
                            if (servlet != null)
                            {
                                final String currentClass = servlet.getServletClass() ;
                                if (servletClass.equals(currentClass))
                                {
                                    if (servlet.getLoadOnStartup() == -1)
                                    {
                                        servlet.setLoadOnStartup(loadOnStartup) ;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
