/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.soap.wise;

import it.javalinux.wise.core.client.WSMethod;
import it.javalinux.wise.core.client.WebParameter;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import javax.jws.WebParam.Mode;

import org.jboss.aop.joinpoint.MethodInvocation;

/**
 * Aspect used to override parameter array creation within wise invocations.
 * 
 * @author <a href='mailto:Kevin.Conner@jboss.com'>Kevin Conner</a>
 */
public class WSMethodParameterMappingAspect
{
    public Object getParameterInRightPositionArray(final MethodInvocation invocation)
        throws Throwable
    {
        final Object[] args = invocation.getArguments() ;
        final Map<String, Object> params = (Map<String, Object>)args[0] ;

        final WSMethod wsMethod = (WSMethod)invocation.getTargetObject() ;
        final Map<String, WebParameter> webParams = wsMethod.getWebParams() ;
        
        final Object[] result = new Object[webParams.size()] ;
        
        for (Entry<String, WebParameter> entry : webParams.entrySet())
        {
            final String key = entry.getKey() ;
            final Object value = params.get(key) ;
            final WebParameter webParameter = entry.getValue() ;
            final int position = webParameter.getPosition() ;
            result[position] = value ;
        }
        return result ;
    }

    public Object getHoldersResult(final MethodInvocation invocation)
        throws Throwable
    {
        final Object[] args = invocation.getArguments() ;
        final Map<String, Object> params = (Map<String, Object>)args[0] ;

        final WSMethod wsMethod = (WSMethod)invocation.getTargetObject() ;
        final Map<String, WebParameter> webParams = wsMethod.getWebParams() ;
        
        final Map<String, Object> holders = new HashMap<String, Object>() ;
        
        for (Entry<String, WebParameter> entry : webParams.entrySet())
        {
            final WebParameter webParameter = entry.getValue() ;
            final Enum<Mode> mode = webParameter.getMode() ;
            if ((mode == Mode.INOUT) || (mode == Mode.OUT))
            {
                final String key = entry.getKey() ;
                final Object value = params.get(key) ;
                holders.put(key, value) ;
            }
        }
        return holders;
    }
}
