/*
 * JBoss, Home of Professional Open Source Copyright 2006, JBoss Inc., and
 * individual contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of individual
 * contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.visitors;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.couriers.FaultMessageException;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;

/**
 * ServiceDelegateVisitor is a Smooks visitor that delegates to 
 * a JBoss ESB service. 
 * <p>
 * Sample config (smooks-res.xml) :
 * <pre>
 *  &lt;param name="service-category-name"&gt;FirstServiceESB&lt;/param&gt;
 *  &lt;param name="service-name"&gt;sendToJMSQueue&lt;/param&gt;
 * </pre>
 * 
 * This class is intended to be used as a delegator for Smooks Visitors, 
 * like a DOMVisitor or a SAXVisitor.
 * 
 * @author <a href="mailto:daniel.bevenius@gmail.com">Daniel Bevenius</a>				
 * @deprecated Use {@link org.jboss.soa.esb.smooks.FragmentRouter}
 */
public class ServiceDelegator 
{
	private Logger log = Logger.getLogger( ServiceDelegator.class );
	
    public static final String SERVICE_NAME_ATTR = "service-name";
	public static final String SERVICE_CATEGORY_NAME_ATTR = "service-category-name";
	
	private String serviceCategoryName;
	private String serviceName;
	
	private SmooksResourceConfiguration resourceConfig;
	private ServiceInvoker serviceInvoker;

	public void setConfiguration( SmooksResourceConfiguration config ) throws SmooksConfigurationException
	{
		if ( config == null )
			throw new SmooksConfigurationException( " SmooksResourceConfig was null." );
		
		resourceConfig = config;
		
		serviceCategoryName = resourceConfig.getStringParameter( SERVICE_CATEGORY_NAME_ATTR );
		if ( serviceCategoryName == null )
			throw new SmooksConfigurationException( "[" + SERVICE_CATEGORY_NAME_ATTR + "] must be set.");
		
		serviceName = resourceConfig.getStringParameter( SERVICE_NAME_ATTR );
		if ( serviceName == null )
			throw new SmooksConfigurationException( "[" + SERVICE_NAME_ATTR + "] must be set.");
		try
		{
			serviceInvoker = createServiceInvoker( serviceCategoryName, serviceName );
		} 
		catch (MessageDeliverException e)
		{
			log.error( "Could not create a ServiceInvoker", e );
			throw new SmooksConfigurationException ( e );
		}
	}
	
	public Message delegateToESBServiceSync( final Message message, final long timeout ) throws FaultMessageException, MessageDeliverException, RegistryException
	{
		Message returnedMessage = null;
		if ( message != null )
			returnedMessage =  serviceInvoker.deliverSync( message, timeout );
		
		return returnedMessage;
	}
	
	public void delegateToESBService( final Message message ) throws MessageDeliverException
	{
		if ( message != null )
			serviceInvoker.deliverAsync( message );
	}

	public String getServiceCategoryName()
	{
		return serviceCategoryName;
	}
	
	public String getServiceName()
	{
		return serviceName;
	}
	
	protected ServiceInvoker createServiceInvoker( final String serviceCategoryName, final String serviceName ) throws MessageDeliverException
	{
		return new ServiceInvoker( serviceCategoryName, serviceName );
	}

}
