/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

/**
 * Routes the Message argument to a fixed list of services ([category,name]) 
 * @author kstam@redhat.com
 * @since Version 4.2
 */
package org.jboss.soa.esb.actions;

import java.util.List;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.services.routing.MessageRouterException;

public class MessageFilter extends ContentBasedRouter
{
    public static final String ROUTE_TO_TAG = "route-to";

    private Logger log = Logger.getLogger(this.getClass());

    public MessageFilter(ConfigTree config) throws ConfigurationException,
	    RegistryException, MessageRouterException
    {
	super(config);
    }

    /**
         * Inspect the content of the message using a rule set Router the
         * message to one or more destinations, using the ContentBasedRouter to
         * figure out to which destinations it is going to be routed too.
         * 
         * @param message
         * @return Message
         * @throws ActionProcessingException
         */
    public Message process (Message message) throws ActionProcessingException
    {
	try
	{
        List<Service> outgoingDestinations = executeRules(message);
        
        if (outgoingDestinations.size()==0) {
            log.debug("No destinations where matched, the Message is filtered");
        } else {
            routeMessage(message, outgoingDestinations);
        }
	}
	catch (MessageRouterException mre)
	{
	    throw new ActionProcessingException(mre.getMessage(), mre);
	}
	
	return null;
    }



}
