/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2010
 */
package org.jboss.internal.soa.esb.services.rules;

import org.apache.log4j.Logger;
import org.drools.SystemEventListener;
import org.drools.SystemEventListenerFactory;
import org.drools.agent.impl.PrintStreamSystemEventListener;
import org.drools.core.util.DelegatingSystemEventListener;
import org.drools.io.ResourceChangeScanner;
import org.drools.io.ResourceChangeScannerConfiguration;
import org.drools.io.ResourceFactory;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.system.ServiceMBeanSupport;

/**
 * DroolsResourceChangeService.
 * 
 * @author dward at jboss.org
 */
public class DroolsResourceChangeService extends ServiceMBeanSupport implements DroolsResourceChangeServiceMBean
{
	
	private static final Logger logger = Logger.getLogger(DroolsResourceChangeService.class);
	
	private static final String DROOLS_RESOURCE_SCANNER_INTERVAL = "drools.resource.scanner.interval";
	
	private SystemEventListener originalSystemEventListener = null;
	
	@Override
	protected void startService() throws Exception
	{
		// ORDER IS IMPORTANT!
		
		// 1) set the system event listener to our implementation
		originalSystemEventListener = SystemEventListenerFactory.getSystemEventListener();
		if (originalSystemEventListener == null || originalSystemEventListener instanceof DelegatingSystemEventListener)
		{
			// We need to check for DelegatingSystemEventListener so we don't get a
			// StackOverflowError when we set it back.  If it is a DelegatingSystemEventListener,
			// we instead use what drools wraps by default, which is PrintStreamSystemEventListener.
			// Refer to org.drools.impl.SystemEventListenerServiceImpl for more information.
			originalSystemEventListener = new PrintStreamSystemEventListener();
		}
		SystemEventListenerFactory.setSystemEventListener(new LogSystemEventListener());
		
		// 2) start the notifier
		ResourceFactory.getResourceChangeNotifierService().start();
		
		// 3) start the scanner
		ResourceChangeScanner rcs = ResourceFactory.getResourceChangeScannerService();
		ResourceChangeScannerConfiguration rcs_conf = rcs.newResourceChangeScannerConfiguration();
		String rulesResourceScannerInterval = Configuration.getRulesResourceScannerInterval();
		if (logger.isInfoEnabled())
		{
			logger.info("setting " + DROOLS_RESOURCE_SCANNER_INTERVAL + " to " + rulesResourceScannerInterval);
		}
		rcs_conf.setProperty(DROOLS_RESOURCE_SCANNER_INTERVAL, rulesResourceScannerInterval);
		rcs.configure(rcs_conf);
		rcs.start();
		
		// 4) start the super
		super.startService();
	}
	
	@Override
	protected void stopService() throws Exception
	{
		// ORDER IS IMPORTANT!
		
		// 1) stop the scanner
		ResourceFactory.getResourceChangeScannerService().stop();
		
		// 2) stop the notifier
		ResourceFactory.getResourceChangeNotifierService().stop();
		
		// 3) set the system event listener back to the original implementation
		SystemEventListenerFactory.setSystemEventListener(originalSystemEventListener);
		
		// 4) stop the super
		super.stopService();
	}
	
}