/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.soa.esb.services.jbpm.integration.scheduled;

import javax.jms.JMSException;
import javax.jms.Message;

import org.jboss.soa.esb.services.jbpm.integration.JmsScheduledDeliveryStrategy;


/**
 * Strategy class for JMS scheduled deliveries.
 */
public class JBossMessagingScheduledDeliveryStrategy implements JmsScheduledDeliveryStrategy
{
    /**
     * Name of the JBoss Messaging property which drives scheduled delivery.
     */
    private static final String JMS_JBOSS_SCHEDULED_DELIVERY_PROP_NAME = "JMS_JBOSS_SCHEDULED_DELIVERY" ;
    
    /**
     * Initialise the scheduled delivery properties on the JMS message.
     * @param message The JMS message representing the scheduled job.
     * @param time The time when the JMS message should be delivered.
     * @throws JMSException for errors initialising the scheduled delivery.
     */
    public void initialiseScheduledDelivery(final Message message, final long time)
        throws JMSException
    {
        message.setLongProperty(JMS_JBOSS_SCHEDULED_DELIVERY_PROP_NAME, time) ;
    }
}
