package org.jboss.soa.esb.services.jbpm.integration.command;

import javax.jms.JMSException;
import javax.jms.Message;

import org.jboss.soa.esb.services.jbpm.integration.job.ExecuteJobCommand;
import org.jboss.soa.esb.services.jbpm.integration.job.ExecuteTimerCommand;
import org.jbpm.command.Command;

/**
 * Based on the jBPM enterprise code, this class handles specialisation
 * associated with job and timer executor.
 * 
 * @author <a href='kevin.conner@jboss.com'>Kevin Conner</a>
 */
public class JobListener extends AbstractMessageListener
{
    /**
     * Extract a job or timer reference from the message.
     * @param message The message containing the job or timer reference.
     * @throws JMSException For errors during extraction.
     */
    protected Command extractCommand(Message message)
        throws JMSException
    {
        Command command = null;
        // checking for availability of the jobId property
        if (log.isDebugEnabled()) {
            log.debug("getting job id from jms message...");
        }
        Long jobId = (Long) message.getObjectProperty("jobId");
        if (jobId != null) {
            if (log.isDebugEnabled()) {
                log.debug("retrieved jobId '"+jobId+"' via jms message");
            }
            command = new ExecuteJobCommand(jobId.longValue(), message.getJMSRedelivered());
        } else {
            Long timerId = (Long) message.getObjectProperty("timerId");
            if (timerId != null) {
                if (log.isDebugEnabled()) {
                    log.debug("retrieved timerId '"+timerId+"' via jms message");
                }
                command = new ExecuteTimerCommand(timerId.longValue(), message.getJMSRedelivered());
            } else {
                log.warn("ignoring message '"+message+"' cause it doesn't have property jobId");
            }
        }
        return command;
    }
}
