/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.jbpm.configuration;

import org.jboss.system.ServiceMBeanSupport;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.job.executor.JobExecutor;

/**
 * MBean controlling the jBPM service initialisation.
 * 
 * It's only purpose at present is to control the lifecycle of the default
 * jBPM job executor.
 * 
 * @author <a href="mailto:kevin.conner@jboss.com">Kevin Conner</a>
 */
public class JbpmService extends ServiceMBeanSupport implements JbpmServiceMBean
{
    @Override
    protected void startService()
        throws Exception
    {
        final JbpmConfiguration jbpmConfiguration = JbpmConfiguration.getInstance() ;
        final JobExecutor jobExecutor = jbpmConfiguration.getJobExecutor() ;
        if (jobExecutor != null)
        {
            jobExecutor.start() ;
        }
        final JbpmContext jbpmContext = jbpmConfiguration.createJbpmContext() ;
        jbpmContext.close() ;
        super.startService();
    }

    @Override
    protected void stopService()
        throws Exception
    {
        super.stopService();
        final JbpmConfiguration jbpmConfiguration = JbpmConfiguration.getInstance() ;
        final JobExecutor jobExecutor = jbpmConfiguration.getJobExecutor() ;
        if (jobExecutor != null)
        {
            jobExecutor.stopAndJoin() ;
        }
        jbpmConfiguration.close() ;
    }
}
