/**
 * 
 */
package org.jboss.soa.esb.services.jbpm;

import java.io.Serializable;

import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.jboss.soa.esb.helpers.ConfigTree;

/**
 * @author kstam
 *
 */
public class Mapping implements Serializable
{
    private static final long serialVersionUID = 1L;
    private String bpm;
    private String esb;
    private Boolean isProcessScope;
    private String defaultValue;
    private static transient Logger log = Logger.getLogger(Mapping.class);
    
    public String getBpm() {
        return bpm;
    }
    public void setBpm(String bpm) {
        this.bpm = bpm;
    }
    public String getDefaultValue() {
        return defaultValue;
    }
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }
    public String getEsb() {
        return esb;
    }
    public void setEsb(String esb) {
        this.esb = esb;
    }
    public Boolean getIsProcessScope() {
        return isProcessScope;
    }
    public void setIsProcessScope(Boolean isProcessScope) {
        this.isProcessScope = isProcessScope;
    }
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Mapping[ esb=").append(esb)
               .append(", bpm=").append(bpm)
               .append(", isProcessScope=").append(isProcessScope)
               .append(", defaultValue=").append(defaultValue).append(" ]");
        return builder.toString();
    }
    
    public boolean equals(final Object obj)
    {
        if (this == obj)
            return true;
        if (!(obj instanceof Mapping))
            return false;
        
        Mapping mapping = (Mapping) obj;
        return (bpm == mapping.bpm || bpm != null && bpm.equals(mapping.bpm)) && 
            (esb == mapping.esb || esb != null && esb.equals(mapping.esb)) &&
            (defaultValue == mapping.defaultValue || defaultValue != null && defaultValue.equals(mapping.defaultValue)) &&
            (isProcessScope == mapping.isProcessScope || isProcessScope != null && isProcessScope.equals(mapping.isProcessScope));
    }
    
    public int hashCode()
    {
        int hash = 7;
        hash = 31 * hash + (null == bpm ? 0 : bpm.hashCode());
        hash = 31 * hash + (null == esb ? 0 : esb.hashCode());
        hash = 31 * hash + (null == defaultValue ? 0 : defaultValue.hashCode());
        hash = 31 * hash + (null == isProcessScope ? 0 : isProcessScope.hashCode());
        return hash;
    }
    
    /**
     * 
     * @param mappingElement
     * @return
     */
    public static Mapping parseMappingElement(Element mappingElement)
    {
        Mapping mapping = new Mapping();
        mapping.setEsb(mappingElement.attributeValue(Constants.ESB_VARNAME_TAG));
        mapping.setBpm(mappingElement.attributeValue(Constants.BPM_VARNAME_TAG));
        mapping.setDefaultValue(mappingElement.attributeValue(Constants.DEFAULT_VALUE_TAG));
        final String isProcessScope = mappingElement.attributeValue(Constants.PROCESS_SCOPE_ATTR) ;
        if (isProcessScope != null) {
            mapping.setIsProcessScope(Boolean.valueOf(isProcessScope));
        }
        if (log.isDebugEnabled()) log.debug(mappingElement.asXML() + ":" + mapping);
        return mapping;
    }
    
    /**
     * 
     * @param mappingElement
     * @return
     */
    public static Mapping parseMappingElement(ConfigTree mappingElement)
    {
        Mapping mapping = new Mapping();
        mapping.setEsb(mappingElement.getAttribute(Constants.ESB_VARNAME_TAG));
        mapping.setBpm(mappingElement.getAttribute(Constants.BPM_VARNAME_TAG));
        mapping.setDefaultValue(mappingElement.getAttribute(Constants.DEFAULT_VALUE_TAG));
        final String isProcessScope = mappingElement.getAttribute(Constants.PROCESS_SCOPE_ATTR) ;
        if (isProcessScope != null) {
            mapping.setIsProcessScope(Boolean.valueOf(isProcessScope));
        }
        if (log.isDebugEnabled()) log.debug(mappingElement.toXml() + ":" + mapping);
        return mapping;
    }
}
