<xsl:stylesheet version="1.0" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns="urn:jboss:bean-deployer:2.0"
    xmlns:sbm="urn:jboss:bean-deployer:2.0"
    exclude-result-prefixes="sbm">
    <xsl:output method="xml" indent="yes" encoding="UTF-8"/>
    
    
    <xsl:template match="/sbm:deployment">
        <xsl:call-template name="add-xslt-beans">
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template match="/sbm:deployment/sbm:bean[@name='SystemPropertyBinder']/sbm:constructor/sbm:parameter/sbm:set">
        <xsl:call-template name="add-system-property">
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template match="/sbm:deployment/sbm:bean/sbm:constructor/sbm:parameter/sbm:set[@elementClass='org.jboss.services.binding.ServiceBindingMetadata']">
        <xsl:call-template name="add-to-standard-bindings">
            <xsl:with-param name="jndiPort" select="1099"/>
            <xsl:with-param name="webPort" select="8080"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="add-xslt-beans">
        <xsl:copy xml:space="preserve"><xsl:apply-templates select="@*|node()"/>
   <xsl:text>
   </xsl:text>
   <xsl:comment>ESB XSL Transform to apply to jbossesb-properties.xml</xsl:comment><xsl:text>
   </xsl:text>
   <bean name="EsbPropertyServiceXSLTConfig" class="org.jboss.services.binding.impl.XSLTServiceBindingValueSourceConfig"><xsl:text>
       </xsl:text>
       <constructor><xsl:text>
           </xsl:text>
        <parameter>
                &lt;xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version='1.0'&gt;
                    &lt;xsl:output method="xml"/&gt;
                    &lt;xsl:param name="port"/&gt;
                    &lt;xsl:param name="esbHost"/&gt;

                    &lt;xsl:template match="/"&gt;
                        &lt;xsl:apply-templates/&gt;
                    &lt;/xsl:template&gt;

                    &lt;xsl:template match="property[@name='org.jboss.soa.esb.jndi.server.url']"&gt;
                       &lt;xsl:element name="property"&gt;
                          &lt;xsl:attribute name="name"&gt;org.jboss.soa.esb.jndi.server.url&lt;/xsl:attribute&gt;
                          &lt;xsl:attribute name="value"&gt;&lt;xsl:value-of select='$esbHost'/&gt;:&lt;xsl:value-of select='$port'/&gt;&lt;/xsl:attribute&gt;
                       &lt;/xsl:element&gt;
                    &lt;/xsl:template&gt;

                    &lt;xsl:template match="*|@*"&gt;
                       &lt;xsl:copy&gt;
                          &lt;xsl:apply-templates select="@*|node()"/&gt;
                       &lt;/xsl:copy&gt;
                    &lt;/xsl:template&gt;
                &lt;/xsl:stylesheet&gt;<xsl:text>
           </xsl:text>
        </parameter><xsl:text>
           </xsl:text>
        <parameter><xsl:text>
               </xsl:text>
            <map keyClass="java.lang.String" valueClass="java.lang.String"><xsl:text>
                   </xsl:text>
                <entry><xsl:text>
                      </xsl:text>
                   <key>esbHost</key><xsl:text>
                      </xsl:text>
                   <value>${jboss.bind.address}</value><xsl:text>
                   </xsl:text>
                </entry><xsl:text>
               </xsl:text>
            </map><xsl:text>
           </xsl:text>
        </parameter><xsl:text>
      </xsl:text>
     </constructor><xsl:text>
   </xsl:text>
   </bean><xsl:text>
   
   </xsl:text>

   <xsl:comment> XSL Transform to apply to juddi-esb.xml </xsl:comment><xsl:text>
   </xsl:text>
   <bean name="EsbJuddiRMIXSLTConfig" class="org.jboss.services.binding.impl.XSLTServiceBindingValueSourceConfig"><xsl:text>
      </xsl:text>
      <constructor><xsl:text>
         </xsl:text>
         <parameter>
                &lt;xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version='1.0'&gt;

                   &lt;xsl:output method="xml"/&gt;
                   &lt;xsl:param name="esbHost"/&gt;
                   &lt;xsl:param name="port"/&gt;
                   &lt;xsl:param name="webPort"/&gt;

                   &lt;xsl:template match="/"&gt;
                      &lt;xsl:apply-templates/&gt;
                   &lt;/xsl:template&gt;

                   &lt;xsl:template match="entry[@key='java.naming.provider.url']"&gt;
                      &lt;entry key="java.naming.provider.url"&gt;jnp://&lt;xsl:value-of select='$esbHost'/&gt;:&lt;xsl:value-of select='$port'/&gt;&lt;/entry&gt;
                   &lt;/xsl:template&gt;

                   &lt;xsl:template match="entry[@key='juddi.discoveryURL']"&gt;
                      &lt;entry key="juddi.discoveryURL"&gt;http://&lt;xsl:value-of select="$esbHost"/&gt;:&lt;xsl:value-of select="$webPort"/&gt;/juddi/uddiget.jsp?&lt;/entry&gt;
                   &lt;/xsl:template&gt;

                   &lt;xsl:template match="entry[@key='juddi.proxy.adminURL']"&gt;
                      &lt;entry key="juddi.proxy.adminURL"&gt;http://&lt;xsl:value-of select="$esbHost"/&gt;:&lt;xsl:value-of select="$webPort"/&gt;/juddi/admin&lt;/entry&gt;
                   &lt;/xsl:template&gt;

                   &lt;xsl:template match="entry[@key='juddi.proxy.inquiryURL']"&gt;
                      &lt;entry key="juddi.proxy.inquiryURL"&gt;http://&lt;xsl:value-of select="$esbHost"/&gt;:&lt;xsl:value-of select="$webPort"/&gt;/juddi/inquiry&lt;/entry&gt;
                   &lt;/xsl:template&gt;

                   &lt;xsl:template match="entry[@key='juddi.proxy.publishURL']"&gt;
                      &lt;entry key="juddi.proxy.publishURL"&gt;http://&lt;xsl:value-of select="$esbHost"/&gt;:&lt;xsl:value-of select="$webPort"/&gt;/juddi/publish&lt;/entry&gt;
                   &lt;/xsl:template&gt;

                   &lt;xsl:template match="*|@*"&gt;
                      &lt;xsl:copy&gt;
                         &lt;xsl:apply-templates select="@*|node()"/&gt;
                      &lt;/xsl:copy&gt;
                   &lt;/xsl:template&gt;
                &lt;/xsl:stylesheet&gt;<xsl:text>
         </xsl:text>
       </parameter><xsl:text>
         </xsl:text>
       <parameter><xsl:text>
              </xsl:text>
              <map keyClass="java.lang.String" valueClass="java.lang.String"><xsl:text>
                  </xsl:text>
                  <entry><xsl:text>
                     </xsl:text>
                     <key>esbHost</key><xsl:text>
                     </xsl:text>
                     <value>${jboss.bind.address}</value><xsl:text>
                  </xsl:text>
                  </entry><xsl:text>
                  </xsl:text>
                  <entry><xsl:text>
                      </xsl:text>
                      <key>webPort</key><xsl:text>
                      </xsl:text>
                      <value>${org.jboss.esb.web.port}</value><xsl:text>
                   </xsl:text>
                  </entry><xsl:text>
              </xsl:text>
              </map><xsl:text>
         </xsl:text>
       </parameter><xsl:text>
      </xsl:text>
      </constructor><xsl:text>
   </xsl:text>
   </bean><xsl:text>

</xsl:text>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template name="add-to-standard-bindings">
        <xsl:copy xml:space="preserve"><xsl:apply-templates select="@*|node()"/>
            <xsl:text>
            </xsl:text>
            <xsl:comment> ************ ESB Standard Bindings configuration ************ </xsl:comment><xsl:text>
            </xsl:text>
            <bean class="org.jboss.services.binding.ServiceBindingMetadata"><xsl:text>
               </xsl:text>
               <property name="serviceName">EsbPropertyService</property><xsl:text>
               </xsl:text>
               <property name="port">1099</property><xsl:text>
               </xsl:text>
               <property name="description">Will process jbossesb-properties using xslt to support substituion of configuration properties.</property><xsl:text>
               </xsl:text>
               <property name="serviceBindingValueSourceConfig"><xsl:text>
                   </xsl:text>
                   <inject bean="EsbPropertyServiceXSLTConfig"/><xsl:text>
               </xsl:text>
               </property><xsl:text>
            </xsl:text>
            </bean><xsl:text>
            
            </xsl:text>

            <bean class="org.jboss.services.binding.ServiceBindingMetadata"><xsl:text>
               </xsl:text>
                <property name="serviceName">EsbJuddiRMIPropertyService</property><xsl:text>
               </xsl:text>
                <property name="port">1099</property><xsl:text>
               </xsl:text>
                <property name="description">Will process juddi-esb.xml using xslt to support substituion of configuration properties .</property><xsl:text>
               </xsl:text>
                <property name="serviceBindingValueSourceConfig"><xsl:text>
                   </xsl:text>
                    <inject bean="EsbJuddiRMIXSLTConfig"/><xsl:text>
               </xsl:text>
                </property><xsl:text>
            </xsl:text>
            </bean><xsl:text>
            
            </xsl:text>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template name="add-system-property">
        <xsl:copy xml:space="preserve"><xsl:apply-templates select="@*|node()"/>
            <xsl:text>
               </xsl:text>
            <xsl:comment>************ ESB System Properties ************ </xsl:comment><xsl:text>
               </xsl:text>
            <bean class="org.jboss.services.binding.SystemPropertyBinding"><xsl:text>
                   </xsl:text>
                <constructor><xsl:text>
                       </xsl:text>
                    <parameter>org.jboss.esb.web.port</parameter><xsl:text>
                       </xsl:text>
                    <parameter class="int"><xsl:text>
                           </xsl:text>
                        <value-factory bean="ServiceBindingManager" method="getIntBinding"><xsl:text>
                               </xsl:text>
                           <parameter>jboss.web:service=WebServer</parameter><xsl:text>
                           </xsl:text>
                       </value-factory><xsl:text>
                       </xsl:text>
                    </parameter><xsl:text>
                  </xsl:text>
                </constructor><xsl:text>
               </xsl:text>
            </bean><xsl:text>
            
            </xsl:text>
        </xsl:copy>
    </xsl:template>
    
    
    <xsl:template name="identity" match="@*|node()">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>
    
</xsl:stylesheet>
