/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.util;

import java.io.ByteArrayInputStream;

import junit.framework.TestCase;

import org.jboss.internal.soa.esb.util.StreamUtils;

/**
 * StreamUtils unit tests.
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class StreamUtilsUnitTest extends TestCase {

	public void test_readStream_badargs() {
		try {
			StreamUtils.readStream(null);
			fail("expected IllegalArgumentException");
		} catch(IllegalArgumentException e) {
			// expected
		}
	}
	
	public void test_readStream() {
		StringBuffer testBuf = new StringBuffer(500);
		@SuppressWarnings("unused")
		byte[] resStream;
		
		while(testBuf.length() < 500) {
			testBuf.append("12121212121212121212121212121212121212121212121212");
		}

		String testString = testBuf.toString();
		String resString = new String(StreamUtils.readStream(new ByteArrayInputStream(testString.getBytes())));
		
		assertEquals(testString, resString);
	}
}
