/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.security.principals;

import static org.junit.Assert.*;
import org.junit.Test;
import junit.framework.JUnit4TestAdapter;

/**
 * Unit test for {@link Role}
 * <p/>
 * 
 * @author <a href="mailto:dbevenius@redhat.com">Daniel Bevenius</a>
 *
 */
public class RoleUnitTest
{
	private Role roleOne = new Role("roleOne");
	private Role role1 = new Role("roleOne");
	private Role roleTwo = new Role("roleTwo");
	private Role role2 = new Role("roleTwo");
	
	@Test (expected = NullPointerException.class)
	public void constuctWithNullRoleName()
	{
		new Role(null);
	}

	@Test
	public void equals()
	{
		assertEquals(roleOne, role1);
		assertFalse(roleOne.equals(role2));
	}
	
	@Test
	public void hashcode()
	{
		assertEquals(roleOne.hashCode(), role1.hashCode());
		assertFalse(roleOne.hashCode() == roleTwo.hashCode());
	}
	
	public static junit.framework.Test suite()
	{
		return new JUnit4TestAdapter(RoleUnitTest.class);
	}
}
