/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.security.auth.ws;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static java.util.concurrent.TimeUnit.NANOSECONDS;

import java.io.InputStream;

import junit.framework.JUnit4TestAdapter;

import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;
import org.jboss.soa.esb.util.ClassUtil;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;


/**
 * Unit test for {@link UsernameTokenExtractor}
 * <p/>
 * 
 * @author <a href="mailto:dbevenius@redhat.com">Daniel Bevenius</a>
 *
 */
public class UsernameTokenExtractorUnitTest
{
	private UsernameTokenExtractor extractor;
	
	/**
	 * Intentionally ignored. Takes some time to run and is indended to be run maually.
	 */
	@Test
    public void performanceExtractSecurityInfo() throws Exception
    {
        final UsernameTokenExtractor  extractor = new UsernameTokenExtractor("http://schemas.xmlsoap.org/ws/2002/04/secext");
        final String soap = createUserPassSoapString("soap-userpass-example.xml");
        AuthenticationRequest authRequest = null;
        
        // warm up 
        for (int i = 0; i < 5000; i++)
        {
            authRequest = extractor.extractSecurityInfo(soap);
        }
        
        int iterations = 1000000;
        long start = System.nanoTime();
        for (int i = 0; i < iterations; i++)
        {
            authRequest = extractor.extractSecurityInfo(soap);
        }
        long duration = System.nanoTime() - start;
        System.out.println(iterations + " took : " + NANOSECONDS.toSeconds(duration) + " s");
        
        assertNotNull(authRequest);
        assertEquals( "Clark", authRequest.getPrincipal().getName());
    }

	@Test
	public void extractSecurityInfo() throws Exception
	{
		UsernameTokenExtractor  extractor = new UsernameTokenExtractor("http://schemas.xmlsoap.org/ws/2002/04/secext");
		String soap = createUserPassSoapString("soap-userpass-example.xml");
		AuthenticationRequest authRequest = extractor.extractSecurityInfo(soap);
		
		assertNotNull(authRequest);
		assertEquals( "Clark", authRequest.getPrincipal().getName());
	}
    
	@Test
	public void processEmptyHeaderWithUserNameElementInBody() throws Exception
	{
		String soap = createUserPassSoapString("soap-userpass-example2.xml");
		AuthenticationRequest authRequest = extractor.extractSecurityInfo(soap);
		assertNull(authRequest);
	}
	
	private String createUserPassSoapString(final String filename) throws Exception
	{
		return getStringFromFile(filename);
	}
	
	private String getStringFromFile(final String fileName ) throws Exception
	{
		InputStream inputStream = ClassUtil.getResourceAsStream(fileName, getClass() );
		return new String(StreamUtils.readStream(inputStream));
	}
	
	@Before
	public void createInstance()
	{
		extractor = new UsernameTokenExtractor("http://schemas.xmlsoap.org/ws/2002/04/secext");
	}

	public static junit.framework.Test suite()
	{
		return new JUnit4TestAdapter(UsernameTokenExtractorUnitTest.class);
	}

}
