/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.security;

import java.util.Map;

import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

/**
 * LoginModule intended for testing perposes. <p/>
 * 
 * @author <a href="mailto:dbevenius@redhat.com">Daniel Bevenius</a>
 */
public class TestLoginModule implements LoginModule
{
	private Subject subject;

	// the authentication status
	private boolean succeeded = false;

	private boolean commitSucceeded = false;

	private String username = "test";

	private TestPrincipal principal;

	private static boolean forceLogin;

	private CallbackHandler callbackHandler;
	
	public void initialize( final Subject subject, final CallbackHandler callbackHandler, final Map<String,?> sharedState, final Map<String,?> options )
	{
		this.subject = subject;
		this.callbackHandler = callbackHandler;
		forceLogin = "true".equalsIgnoreCase( (String) options.get( "forceLogin" ) );
	}

	public boolean login() throws LoginException
	{
		if ( forceLogin )
		{
    		succeeded = true;
    		return true;
		}
		else
		{
    		succeeded = false;
			throw new FailedLoginException( "Login failed" );
		}
	}

	public boolean commit() throws LoginException
	{
		if (succeeded == false)
		{
			return false;
		} 
		else
		{
			principal = new TestPrincipal( username );
			if ( !subject.getPrincipals().contains( principal ) )
			{
				subject.getPrincipals().add( principal );
			}

			// in any case, clean out state
			username = null;

			commitSucceeded = true;
			return true;
		}
	}

	public boolean abort() throws LoginException
	{
		if (succeeded == false)
		{
			return false;
		} 
		else if ( succeeded == true && commitSucceeded == false)
		{
			// login succeeded but overall authentication failed
			succeeded = false;
			username = null;
			principal = null;
		} 
		else
		{
			logout();
		}
		return true;
	}

	public boolean logout() throws LoginException
	{

		subject.getPrincipals().remove( principal );
		succeeded = false;
		succeeded = commitSucceeded;
		username = null;
		principal = null;
		return true;
	}
}
