/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.security;

import static org.junit.Assert.assertNotNull;

import java.net.URL;

import junit.framework.JUnit4TestAdapter;

import org.jboss.soa.esb.common.Environment;
import org.jboss.soa.esb.util.ClassUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * 
 * @author <a href="mailto:dbevenius@redhat.com">Daniel Bevenius</a>
 *
 */
public class SecurityServiceFactoryUnitTest
{
	private String jbossEsbProperties;


	@Test 
	public void getSecurityService() throws Exception
	{
		SecurityService securityService = SecurityServiceFactory.getSecurityService();
		assertNotNull( securityService );
	}
	
	@Before
	public void setup()
	{
        jbossEsbProperties = System.getProperty(Environment.PROPERTIES_FILE);
		URL resource = ClassUtil.getResource("security-properties.xml", getClass());
        System.setProperty(Environment.PROPERTIES_FILE, "abs://" + resource.getFile());
	}
	
	@After
	public void tearDown()
	{
		if ( jbossEsbProperties != null )
            System.setProperty(Environment.PROPERTIES_FILE, jbossEsbProperties);
	}
	
	public static junit.framework.Test suite()
	{
		return new JUnit4TestAdapter(SecurityServiceFactoryUnitTest.class);
	}

}
