/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.message.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import junit.framework.TestCase;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.message.format.MessageType;
import org.jboss.soa.esb.util.Util;

/**
 * Unit tests for the Class class.
 * 
 * @author Mark Little
 */

public class BodyUnitTest extends TestCase
{
	private Logger log = Logger.getLogger( BodyUnitTest.class );
	
	public void testXMLAddString ()
	{
		// get XML message

		Message msg = MessageFactory.getInstance().getMessage(
				MessageType.JBOSS_XML);

		assertEquals((msg != null), true);

		try
		{
			msg.getBody().add("foo", "bar");
			
			assertEquals(msg.getBody().get("foo"), "bar");
			
			final String documentAsString = (String)Util.serialize(msg) ;

			log.debug("Document is "+documentAsString);
			
                        final Message nImpl = Util.deserialize(documentAsString);
			
			assertEquals(nImpl.getBody().get("foo"), "bar");
		}
		catch (Exception ex)
		{
			log.error(ex);
			
			fail(ex.toString());
		}
	}
	
	public void testXMLAddBoolean ()
	{
		// get XML message

		Message msg = MessageFactory.getInstance().getMessage(
				MessageType.JBOSS_XML);

		assertEquals((msg != null), true);

		try
		{
			msg.getBody().add("foo", new Boolean(true));
			
			assertEquals(msg.getBody().get("foo"), new Boolean(true));
			
                        final String documentAsString = (String)Util.serialize(msg) ;

                        log.debug("Document is "+documentAsString);
                        
                        final Message nImpl = Util.deserialize(documentAsString);
			
			assertEquals(nImpl.getBody().get("foo"), new Boolean(true));
		}
		catch (Exception ex)
		{
			fail(ex.toString());
		}
	}
	
	public void testSerializedAddString ()
	{
		// get XML message

		Message msg = MessageFactory.getInstance().getMessage(
				MessageType.JAVA_SERIALIZED);

		assertEquals((msg != null), true);

		try
		{
			msg.getBody().add("foo", "bar");
			
			assertEquals(msg.getBody().get("foo"), "bar");
			
			ByteArrayOutputStream s = new ByteArrayOutputStream();
			ObjectOutputStream o = new ObjectOutputStream(s);
	
			o.writeObject(msg);
			o.close();
			
			ByteArrayInputStream is = new ByteArrayInputStream(s.toByteArray());
			ObjectInputStream io = new ObjectInputStream(is);

			org.jboss.internal.soa.esb.message.format.serialized.MessageImpl nImpl = (org.jboss.internal.soa.esb.message.format.serialized.MessageImpl) io.readObject();
			
			o.close();

			assertEquals(nImpl.getBody().get("foo"), "bar");
		}
		catch (Exception ex)
		{
			fail(ex.toString());
		}
	}
	
	public void testSerializedAddBoolean ()
	{
		// get XML message

		Message msg = MessageFactory.getInstance().getMessage(
				MessageType.JAVA_SERIALIZED);

		assertEquals((msg != null), true);

		try
		{
			msg.getBody().add("foo", new Boolean(true));
			
			assertEquals(msg.getBody().get("foo"), new Boolean(true));
			
			ByteArrayOutputStream s = new ByteArrayOutputStream();
			ObjectOutputStream o = new ObjectOutputStream(s);
	
			o.writeObject(msg);
			o.close();
			
			ByteArrayInputStream is = new ByteArrayInputStream(s.toByteArray());
			ObjectInputStream io = new ObjectInputStream(is);

			org.jboss.internal.soa.esb.message.format.serialized.MessageImpl nImpl = (org.jboss.internal.soa.esb.message.format.serialized.MessageImpl) io.readObject();
			
			assertEquals(nImpl.getBody().get("foo"), new Boolean(true));
		}
		catch (Exception ex)
		{
			fail(ex.toString());
		}
	}
	
}
