package org.jboss.soa.esb.message.format.tests;

import java.net.URI;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessagePlugin;

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author mark.little@jboss.com
 */

/**
 * Used to plug in new message formats dynamically. Each plugin is responsible for
 * returning a message implementation that knows how to serialize its state in a
 * specific manner, e.g., XML or ASN.1.
 *  
 * @author Mark Little
 *
 */

public class ExampleMessagePlugin implements MessagePlugin
{
	private Logger log = Logger.getLogger( ExampleMessagePlugin.class );
	
	public static final String URN = "foobar";
	
	/**
	 * @return the message instance.
	 */
	
	public Message getMessage ()
	{
		return new ExampleMessageImpl();
	}
	
	/**
	 * @return the unique identifier for this message plugin.
	 */
	
	public URI getType ()
	{
		try
		{
			return new URI(URN);
		}
		catch (Exception ex)
		{
			log.error(ex);
			
			return null;
		}
	}
	
	public Object createBodyType (Message m, String type)
	{
		return m.getBody();
	}
}
