package org.jboss.soa.esb.message.format.tests;

import java.io.IOException;
import java.net.URI;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.message.Attachment;
import org.jboss.soa.esb.message.Body;
import org.jboss.soa.esb.message.Context;
import org.jboss.soa.esb.message.Fault;
import org.jboss.soa.esb.message.Header;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.Properties;

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author mark.little@jboss.com
 */

/**
 * Used to plug in new message formats dynamically. Each plugin is responsible for
 * returning a message implementation that knows how to serialize its state in a
 * specific manner, e.g., XML or ASN.1.
 *  
 * @author Mark Little
 *
 */

public class ExampleMessageImpl implements Message
{
	private Logger log = Logger.getLogger( ExampleMessageImpl.class );
	
	/**
     * 
     */
    private static final long serialVersionUID = 1L;

    /**
	 * @return get the header component of the message.
	 */
	
	public Header getHeader ()
	{
		return null;
	}

	/**
	 * @return get the context component of the message.
	 */
	
	public Context getContext ()
	{
		return null;
	}
	
	/**
	 * @return get the body component of the message.
	 */
	
	public Body getBody ()
	{
		return null;
	}

	/**
	 * @return get any faults associated with the message. These should not
	 * be application level faults, but comms level.
	 */
	
	public Fault getFault ()
	{
		return null;
	}
	
	/**
	 * @return get any message attachments.
	 */
	
	public Attachment getAttachment ()
	{
		return null;
	}
	/**
	 * @return get any message properties 
	 */	
	public Properties getProperties() 
	{
		return null;
	}
	
        /**
         * Return a duplicate of this instance. Just serialize and then
         * deserialize.
         */

    public Message copy () throws IOException
    {
        return this;
    }
    
	/**
	 * @return the type of this message.
	 */
	
	public URI getType ()
	{
		try
		{
			return new URI(ExampleMessagePlugin.URN);
		}
		catch (Exception ex)
		{
			log.error(ex);
			
			return null;
		}
	}

}
