/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.listeners.message.mime;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;

import junit.framework.TestCase;

/**
 * 
 * @author <a href="mailto:tom.fennelly@gmail.com">tom.fennelly@gmail.com</a>
 */
public class TextPlainMimeDecoderUnitTest extends TestCase {
	
	public void test_String() throws ConfigurationException, MimeDecodeException {
		TextPlainMimeDecoder decoder = new TextPlainMimeDecoder();
		ConfigTree config = new ConfigTree("conf");
		
		decoder.setConfiguration(config);
		
		String decodedRes = (String) decoder.decode("Hello W".getBytes());
		assertEquals("Hello W", decodedRes);
	}
	
	public void test_Chars() throws ConfigurationException, MimeDecodeException {
		TextPlainMimeDecoder decoder = new TextPlainMimeDecoder();
		ConfigTree config = new ConfigTree("conf");
		
		config.setAttribute("decodeTo", "CHARS");
		decoder.setConfiguration(config);
		
		char[] decodedRes = (char[]) decoder.decode("Hello W".getBytes());
		assertEquals("Hello W", new String(decodedRes));
	}
}
