/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.listeners.message;

import org.jboss.soa.esb.actions.ActionLifecycleException;
import org.jboss.soa.esb.actions.ActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;

public class NPEActionProcessor implements ActionPipelineProcessor
{
    private final Integer id ;
    private final Integer anotherId ;
    
    public NPEActionProcessor(final ConfigTree tree)
    {
        id = MockActionInfo.getNextId() ;
        anotherId = MockActionInfo.getNextId() ;
    }
    
    public Message process(Message message) throws ActionProcessingException
    {
        throw new NullPointerException();
    }
    
    public Message anotherProcess(Message message) throws ActionProcessingException
    {
    	throw new NullPointerException();
    }

    public void processException(Message message, Throwable th)
    {
        MockActionInfo.addExceptionId(id) ;
    }

    public void anotherProcessException(Message message, Throwable th)
    {
        MockActionInfo.addExceptionId(anotherId) ;
    }

    public void processSuccess(Message message)
    {
        MockActionInfo.addSuccessId(id) ;
    }

    public void anotherProcessSuccess(Message message)
    {
        MockActionInfo.addSuccessId(anotherId) ;
    }

    public void destroy() throws ActionLifecycleException
    {
        MockActionInfo.addDestroyId(id) ;
    }

    public void initialise() throws ActionLifecycleException
    {
        MockActionInfo.addInitialiseId(id) ;
    }
}
