/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.listeners.message;

import java.util.Set;

import org.jboss.internal.soa.esb.services.security.SecurityContextPropagator;
import org.jboss.soa.esb.services.security.SecurityConfig;
import org.jboss.soa.esb.services.security.SecurityContext;

/**
 * Mock SecurityContextPropagator used in unit tests.
 *
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 */
public class MockSecurityContextPropagator implements SecurityContextPropagator
{
    private static boolean pushCalled;
    private static SecurityContext pushSecurityContext;

    private static boolean popCalled;
    private static SecurityContext popSecurityContext;

    public void popSecurityContext(final SecurityContext context, final SecurityConfig config)
    {
        popCalled = true;
    }

    public void pushSecurityContext(final SecurityContext context, final Set<?> creds, final SecurityConfig config)
    {
        pushCalled = true;
    }

    public static boolean wasPopCalled()
    {
        return popCalled;
    }

    public static boolean wasPushCalled()
    {
        return pushCalled;
    }

    public static SecurityContext getPopSecurityContext()
    {
        return popSecurityContext;
    }

    public static SecurityContext getPushSecurityContext()
    {
        return pushSecurityContext;
    }

}
