/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.listeners.deployers.mc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;

import org.jboss.deployers.vfs.plugins.structure.AbstractVFSDeploymentUnit;
import org.jboss.deployers.vfs.plugins.structure.VFSStructuralDeployersImpl;
import org.jboss.deployers.vfs.plugins.structure.VFSStructureBuilder;
import org.jboss.deployers.vfs.plugins.structure.jar.JARStructure;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
import org.jboss.deployers.vfs.spi.structure.StructureDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentContext;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.deployment.DeploymentException;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

/**
 * Util methods used with Microcontainer tests.
 * </p>
 * 
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 */
public class TestUtil
{
    private TestUtil() { }

    public static VFSDeploymentUnit getDeploymentUnit(final VirtualFile esbArchive) throws Exception
    {
        VFSDeploymentContext deploymentContext = getDeploymentContext(esbArchive);
        deploymentContext.setClassLoader(TestUtil.class.getClassLoader());
        return getDeploymentUnit(deploymentContext);
    }

    public static VFSDeploymentUnit getDeploymentUnit(final VFSDeploymentContext deploymentContext)
    {
        return new AbstractVFSDeploymentUnit(deploymentContext);
    }

    public static VFSDeploymentContext getDeploymentContext(final VirtualFile esbArchive) throws Exception
    {
        VFSDeployment deployment = VFSDeploymentFactory.getInstance().createVFSDeployment(esbArchive);
        VFSStructuralDeployersImpl structuralDeployers = new VFSStructuralDeployersImpl();
        VFSStructureBuilder builder = new VFSStructureBuilder();
        structuralDeployers.setStructureBuilder(builder);
        StructureDeployer[] deployers = new StructureDeployer[]{new JARStructure()};
        for (StructureDeployer deployer : deployers)
        {
            structuralDeployers.addDeployer(deployer);
        }
        return (VFSDeploymentContext) structuralDeployers.determineStructure(deployment);
    }

    public static VirtualFile getVirtualFile(final URL directoryURL, final String fileName, final Class<?> clazz) throws Exception
    {
        return VFS.getVirtualFile(directoryURL, fileName);
    }

    public static VirtualFile getMockVF(final File esbFile)
    {
        VirtualFile file = new VirtualFile(new VirtualFileHandler()
        {
            private static final long serialVersionUID = 1L;

            public void close()
            {
            }

            public boolean exists() throws IOException
            {
                return false;
            }

            public VirtualFileHandler getChild(String arg0) throws IOException
            {
                return null;
            }

            public List<VirtualFileHandler> getChildren(boolean arg0) throws IOException
            {
                return null;
            }

            public long getLastModified() throws IOException
            {
                return 0;
            }

            public String getName()
            {
                return esbFile.getName();
            }

            public VirtualFileHandler getParent() throws IOException
            {
                return null;
            }

            public String getPathName()
            {
                return esbFile.getAbsolutePath();
            }

            public long getSize() throws IOException
            {
                return 0;
            }

            public VFSContext getVFSContext()
            {
                return null;
            }

            public VirtualFile getVirtualFile()
            {
                return null;
            }

            public boolean hasBeenModified() throws IOException
            {
                return false;
            }

            public boolean isHidden() throws IOException
            {
                return false;
            }

            public boolean isLeaf() throws IOException
            {
                return false;
            }

            public String getLocalPathName()
            {
                return null;
            }

            public boolean isNested() throws IOException
            {
                return false;
            }

            public InputStream openStream() throws IOException
            {
                return null;
            }

            public URI toURI() throws URISyntaxException
            {
                return null;
            }

            public URL toURL() throws MalformedURLException, URISyntaxException
            {
                return null;
            }

            public URL toVfsUrl() throws MalformedURLException, URISyntaxException
            {
                return null;
            }

            public void replaceChild(VirtualFileHandler original, VirtualFileHandler replacement)
            {
            }

            public boolean removeChild(String name) throws IOException
            {
                return false;
            }

            public boolean delete(int gracePeriod) throws IOException
            {
                return false;
            }

            public void cleanup()
            {
            }

            public URL getRealURL() throws IOException, URISyntaxException
            {
                
                return null;
            }

            public boolean isArchive() throws IOException
            {
                
                return false;
            }
        });
        return file;
    }
    
    public static VFSDeploymentUnit getDeploymentUnit(final URL dir, final String archiveName) throws Exception
    {
        VirtualFile virtualFile = TestUtil.getVirtualFile(dir, archiveName, TestUtil.class);
        return TestUtil.getDeploymentUnit(virtualFile);
    }
    
    public static EsbMetaData getEsbMetaData(final EsbConfigParser parserDeployer, final URL dir, final String archiveName) throws Exception, DeploymentException
    {
        VirtualFile virtualFile = TestUtil.getVirtualFile(dir, archiveName, TestUtil.class);
        VFSDeploymentUnit deploymentUnit = getDeploymentUnit(dir, archiveName);
        return parserDeployer.parse(deploymentUnit, virtualFile, (EsbMetaData)null);
    }
}
